/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#include "marDicomBase.h"

#include <vtkVersionMacros.h>
#include <vtkVolume16Reader.h> 
#include <vtkExtractVOI.h>
#include <vtkImageChangeInformation.h>
#include "vtkMetaImageWriter.h"



marFilesBase::marFilesBase( marParameters* p  ) :  marObject( p ) {
	_volume=NULL;
}
// -------------------------------------------------------------------------
marFilesBase::~marFilesBase(){
	freeVolume( );
}
// -------------------------------------------------------------------------
kVolume* marFilesBase::getVolume( ){
	return( _volume );
}
// -------------------------------------------------------------------------
void marFilesBase::SetVolume( kVolume* volume  ){
	_volume=volume;
}
// -------------------------------------------------------------------------
bool marFilesBase::volumeLoaded( ){
	return( _volume != NULL );
}
// -------------------------------------------------------------------------
void marFilesBase::freeVolume( ){
	if( _volume ) delete _volume;
	_volume = NULL;
}


// -------------------------------------------------------------------------

std::vector < std::string*>  *marFilesBase::GetListImages()
{
	return &_lstString;
}

// -------------------------------------------------------------------------
void marFilesBase::CleanListImages()
{
	int i,size;
	size=this->_lstString.size();
	for(i=0;i<size;i++)
	{
		delete _lstString[i];
	}
	_lstString.clear();
}


// -------------------------------------------------------------------------
void marFilesBase::ResetLstFileNotReaded()
{
	_lstFileNotReaded.clear();
}


// -------------------------------------------------------------------------
std::string marFilesBase::GetMsgLstFile()
{
	int i,sizeLst;
//EEDx44
	std::string msgLstFile="";
	sizeLst=_lstFileNotReaded.size();
	for (i=0;i<sizeLst;i++)
	{
		msgLstFile = msgLstFile + *(_lstFileNotReaded[i]) ;
		msgLstFile = msgLstFile + "\n";
	}

	return msgLstFile;
}






// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
marRAWFiles::marRAWFiles(marParameters* p)
:  marFilesBase(p)
{
	_littreEndianBigEndian=0;
}
// -------------------------------------------------------------------------
marRAWFiles::~marRAWFiles()
{
}
// -------------------------------------------------------------------------
//EED 9 oct 2006
bool marRAWFiles::loadImage(int i) // virtual
{

	int dim[3];

	vtkImageData *vol = getVolume( )->castVtk();
	void *p_vol=(void*)getVolume( )->castVtk()->GetScalarPointer(0,0,i);
	vol->GetDimensions(dim);

	int dataSize = sizeof(unsigned short)*dim[0]*dim[1];
	bool ok=true;

/*
	std::string *ss = _lstString[i];
	FILE *ff=fopen( (char*)(ss->c_str())  , "r+" );
	fread( (char*)p_vol , dataSize,1, ff);
	fclose(ff);
*/

	std::string *ss = _lstString[i];
	vtkVolume16Reader *reader = vtkVolume16Reader::New ();
	reader->SetDataDimensions ( dim[0] , dim[1] );
	if (_littreEndianBigEndian == 0) {
	    reader->SetDataByteOrderToLittleEndian ( );
	} else {
		reader->SetDataByteOrderToBigEndian();
	}
	reader->SetFilePrefix ( (char*)(ss->c_str())  );
	reader->SetFilePattern("%s");
    reader->SetImageRange ( 0, 0 );
    reader->SetDataSpacing ( 1, 1, 1 );
    reader->Update ();
	void *pp_vol=(void*)reader->GetOutput()->GetScalarPointer(0,0,0);
	memcpy(p_vol,pp_vol,dataSize);
	reader->Delete();


/*

	std::string *ss = _lstString[i];
	vtkGsmisReader *reader = vtkGsmisReader::New();
	reader->SetFileName( (char*)(ss->c_str())  );
	vtkImageData *ima=reader->GetOutput();
	ima->Update();
	void *pp_vol=(void*)ima->GetScalarPointer(0,0,0);
	memcpy(p_vol,pp_vol,dataSize);
//	reader->Delete();
*/



/*
	int		ii;
	char	tmp;
	char	*pp = (char*)p_vol;
	unsigned short   *valueA;
	dataSize	= dim[0]*dim[1];
	for (ii=0;ii<dataSize;ii++)
	{
		tmp		= *pp;
		*pp		= *(pp+1);
		*(pp+1)	= tmp;

		valueA=(unsigned short*)pp;
		*valueA=*valueA-32000;
		if (*valueA>=32000)
		{
			*valueA=0;
		} 

		pp		= pp+2;
	}
*/

	if (ok==false) {
		_lstFileNotReaded.push_back( (char*)(ss->c_str()) );
	}

	return ok;
}
// -------------------------------------------------------------------------
//EED 9 oct 2006
void marRAWFiles::loadActualSerie(wxGauge* gauge )
{

	// Read File List
	FILE *ff;
	ff = fopen( _lstString[0] -> c_str() , "r"); 
	std::string directory(*(_lstString[1]) );
	char tmp[255];

	fscanf(ff,"%s",tmp);
	fscanf(ff,"%s",tmp);
	//int type =	atoi(tmp);  // 0 // JPRx

	fscanf(ff,"%s",tmp);
	fscanf(ff,"%s",tmp);
	int wx	=	atoi(tmp);
	fscanf(ff,"%s",tmp);
	fscanf(ff,"%s",tmp);
	int wy	=	atoi(tmp);

	fscanf(ff,"%s",tmp);
	fscanf(ff,"%s",tmp);
	double spx	=	atof(tmp);
	fscanf(ff,"%s",tmp);
	fscanf(ff,"%s",tmp);
	double spy	=	atof(tmp);
	fscanf(ff,"%s",tmp);
	fscanf(ff,"%s",tmp);
	double spz	=	atof(tmp);

	fscanf(ff,"%s",tmp);
	fscanf(ff,"%s",tmp);
	int LB	=	atoi(tmp);

	this->SetLittreEndianBigEndian(LB);


	int wz=0;
	this->CleanListImages();
	while ( !feof(ff) )
	{
		fscanf(ff,"%s",tmp);
		std::string *tmpStr =  new std::string(tmp);
		(*tmpStr) = "/"+(*tmpStr);
		(*tmpStr) = (directory)+(*tmpStr);
		_lstString.push_back( tmpStr);
		wz++;
	}

	fclose(ff);


	// Create Free Memory block image
	freeVolume();

	if (wz==0)
	{
		wz=1;
	}

	kVolume *vol =new kVolume( kVolume::USHORT, wx, wy, wz,spx, spy, spz, malloc(sizeof(unsigned short)*wx*wy*wz ) );
	SetVolume( vol );


	// Define Spacing
	getParameters( )->setDoubleParam( marParameters::e_voxel_x_dimension, spx );
	getParameters( )->setDoubleParam( marParameters::e_voxel_y_dimension, spy );
	getParameters( )->setDoubleParam( marParameters::e_voxel_z_dimension, spz );

	// Define Intercept Slope
	getParameters( )->setDoubleParam( marParameters::e_RescaleIntercept , 0 );
	getParameters( )->setDoubleParam( marParameters::e_RescaleSlope     , 1 );
}
// -------------------------------------------------------------------------
void marRAWFiles::SetLittreEndianBigEndian(int value)
{
	_littreEndianBigEndian = value;
}
// -------------------------------------------------------------------------
int	marRAWFiles::GetLittreEndianBigEndian()
{
	return _littreEndianBigEndian;
}
// -------------------------------------------------------------------------
void marRAWFiles::reset( )
{
}
// -------------------------------------------------------------------------
void marRAWFiles::copyFrom( const marObject& from )
{
}
// -------------------------------------------------------------------------
bool marRAWFiles::save( std::ofstream& os )
{
	return true;
}
// -------------------------------------------------------------------------
bool marRAWFiles::load( std::ifstream& is )
{
	return true;
}


//-------------------------------------------------------------------------
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
marRAW2AsciiFiles::marRAW2AsciiFiles(marParameters* p)
:  marRAWFiles(p)
{
}
// -------------------------------------------------------------------------
marRAW2AsciiFiles::~marRAW2AsciiFiles()
{
}
// -------------------------------------------------------------------------
bool marRAW2AsciiFiles::loadImage(int i) // virtual
{
	return true;
}


// -------------------------------------------------------------------------
//EED 9 oct 2006
void marRAW2AsciiFiles::loadActualSerie(wxGauge* gauge )
{

	// Read File List
	FILE *ff;
	ff = fopen( _lstString[0] -> c_str() , "r"); 
	char tmp[255];

	// type
	fscanf(ff,"%s",tmp);
	fscanf(ff,"%s",tmp);
	//int type =	atoi(tmp);  // 300  // JPRx

	//size x,y,z
	fscanf(ff,"%s",tmp);
	fscanf(ff,"%s",tmp);
	int wx	=	atoi(tmp);
	fscanf(ff,"%s",tmp);
	fscanf(ff,"%s",tmp);
	int wy	=	atoi(tmp);
	fscanf(ff,"%s",tmp);
	fscanf(ff,"%s",tmp);
	int wz	=	atoi(tmp);

	// spacing x,y,z
	fscanf(ff,"%s",tmp);
	fscanf(ff,"%s",tmp);
	double spx	=	atof(tmp);
	fscanf(ff,"%s",tmp);
	fscanf(ff,"%s",tmp);
	double spy	=	atof(tmp);
	fscanf(ff,"%s",tmp);
	fscanf(ff,"%s",tmp);
	double spz	=	atof(tmp);

	// Intercept Slope
	fscanf(ff,"%s",tmp);
	fscanf(ff,"%s",tmp);
	double intercept	=	atof(tmp);
	fscanf(ff,"%s",tmp);
	fscanf(ff,"%s",tmp);
	double slope		=	atof(tmp);


	fscanf(ff,"%s",tmp);
	std::string file(tmp);
	std::string namefile( *_lstString[1] );  // directory
	namefile=namefile+"/";                   // +  
	namefile=namefile+file;                  // file

	fclose(ff);


	this->CleanListImages();

	// Create Free Memory block image
	freeVolume();

	if (wz==0)
	{
		wz=1;
	}

	kVolume *vol =new kVolume( kVolume::USHORT, wx, wy, wz,spx, spy, spz, malloc(sizeof(unsigned short)*wx*wy*wz ) );
	SetVolume( vol );


	// Define Spacing
	getParameters( )->setDoubleParam( marParameters::e_voxel_x_dimension, spx );
	getParameters( )->setDoubleParam( marParameters::e_voxel_y_dimension, spy );
	getParameters( )->setDoubleParam( marParameters::e_voxel_z_dimension, spz );

	// Define Intercept Slope
	getParameters( )->setDoubleParam( marParameters::e_RescaleIntercept , 0 );
	getParameters( )->setDoubleParam( marParameters::e_RescaleSlope     , 1 );


	void	*p_vol	= (void*)getVolume( )->castVtk()->GetScalarPointer(0,0,0);
	short	*pp		= (short*)p_vol;

	FILE *fff=fopen( (char*)namefile.c_str() , "r+" );
	long int ii, dataSize	= wx*wy*wz;
	float value;
	for (ii=0;ii<dataSize;ii++)
	{
		fscanf(fff,"%f ",&value);
		// Intercept Slope
		*pp	= (short)	 ( value*slope + intercept );
		if (*pp<0)
		{
			*pp=0;
		} 
		pp++;
	}
	fclose(fff);


// Y- Flip
//	FlipY( getVolume( )->castVtk() );
	
}


// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
marRAW2Files::marRAW2Files(marParameters* p)
:  marRAWFiles(p)
{
}
// -------------------------------------------------------------------------
marRAW2Files::~marRAW2Files()
{
}
// -------------------------------------------------------------------------
bool marRAW2Files::loadImage(int i) // virtual
{
	return true;
}


// -------------------------------------------------------------------------
//EED 9 oct 2006
void marRAW2Files::loadActualSerie(wxGauge* gauge )
{

	// Read File List
	FILE *ff;
	ff = fopen( _lstString[0] -> c_str() , "r"); 
	char tmp[255];

	// type
	fscanf(ff,"%s",tmp);
	fscanf(ff,"%s",tmp);
	//int type =	atoi(tmp);  // 200  // JPRx

	//size x,y,z
	fscanf(ff,"%s",tmp);
	fscanf(ff,"%s",tmp);
	int wx	=	atoi(tmp);
	fscanf(ff,"%s",tmp);
	fscanf(ff,"%s",tmp);
	int wy	=	atoi(tmp);
//	fscanf(ff,"%s",tmp);
//	fscanf(ff,"%s",tmp);
//	int wz	=	atoi(tmp);

	fscanf(ff,"%s",tmp);
	fscanf(ff,"%s",tmp);
	int wz1	=	atoi(tmp);
	fscanf(ff,"%s",tmp);
	fscanf(ff,"%s",tmp);
	int wz2	=	atoi(tmp);

	int wz = wz2-wz1;
	
	// spacing x,y,z
	fscanf(ff,"%s",tmp);
	fscanf(ff,"%s",tmp);
	double spx	=	atof(tmp);
	fscanf(ff,"%s",tmp);
	fscanf(ff,"%s",tmp);
	double spy	=	atof(tmp);
	fscanf(ff,"%s",tmp);
	fscanf(ff,"%s",tmp);
	double spz	=	atof(tmp);

	// Intercept Slope
	fscanf(ff,"%s",tmp);
	fscanf(ff,"%s",tmp);
	double intercept	=	atof(tmp);
	fscanf(ff,"%s",tmp);
	fscanf(ff,"%s",tmp);
	double slope		=	atof(tmp);

	// L/B
	fscanf(ff,"%s",tmp);
	fscanf(ff,"%s",tmp);
	int littleBig	=	atoi(tmp);

	// bits
	fscanf(ff,"%s",tmp);
	fscanf(ff,"%s",tmp);
	int bits	=	atoi(tmp);

	if ((bits!=8) && (bits!=16)){
		bits=16;
	}
	
	fscanf(ff,"%s",tmp);
	std::string file(tmp);
	std::string namefile( *_lstString[1] );  // directory
	namefile=namefile+"/";                   // +  
	namefile=namefile+file;                  // file

	fclose(ff);


	this->CleanListImages();

	// Create Free Memory block image
	freeVolume();

	if (wz==0)
	{
		wz=1;
	}


	kVolume *vol =new kVolume( kVolume::USHORT, wx, wy, wz,spx, spy, spz, malloc(sizeof(unsigned short)*wx*wy*wz ) );
	SetVolume( vol );


	// Define Spacing
	getParameters( )->setDoubleParam( marParameters::e_voxel_x_dimension, spx );
	getParameters( )->setDoubleParam( marParameters::e_voxel_y_dimension, spy );
	getParameters( )->setDoubleParam( marParameters::e_voxel_z_dimension, spz );

	// Define Intercept Slope
	getParameters( )->setDoubleParam( marParameters::e_RescaleIntercept , 0 );
	getParameters( )->setDoubleParam( marParameters::e_RescaleSlope     , 1 );

	void *p_vol=(void*)getVolume( )->castVtk()->GetScalarPointer(0,0,0);
	FILE *fff=fopen( (char*)namefile.c_str() , "r+" );
    if (bits==16)
    {
		fseek( fff , wx*wy*wz1*2 , SEEK_CUR );
    	fread( (char*)p_vol , wx*wy*wz*2,1, fff);
	    fclose(fff);


	// littleBigEndien
		if (littleBig==1){
			long int		ii;
			char			tmpB;
			char			*pp = (char*)p_vol;
			unsigned short   *valueA;
			long int dataSize	= wx*wy*wz;
			for (ii=0;ii<dataSize;ii++)
			{
				tmpB		= *pp;
				*pp			= *(pp+1);
				*(pp+1)		= tmpB;
				
				valueA= ((unsigned short*)pp);
				if (*valueA>=32000)
				{
					*valueA=0;
				} 
				pp		= pp+2;

			}
		}

		unsigned short			*pp = (unsigned short*)p_vol;
		int tmpInt;
		int ii, dataSize	= wx*wy*wz;
		for (ii=0;ii<dataSize;ii++)
		{
			tmpInt = (int) (*pp);
			tmpInt	= (int)	 ( tmpInt*slope+intercept );
			if (tmpInt<0)
			{
				tmpInt=0;
			} 
			if (tmpInt>65535) 
			{
				tmpInt=65535;
			}
			(*pp) = (unsigned short)tmpInt;
			pp		= pp+1;
		}

    } else {
    	unsigned short *pShort=(unsigned short*)p_vol;
    	int i8bitImage,size8bitImage = wx*wy*wz;
    	unsigned char *pChar=(unsigned char*)malloc( size8bitImage );
		fseek( fff , wx*wy*wz1 , SEEK_CUR );
    	fread( (unsigned char*)pChar , size8bitImage,1, fff);
	    fclose(fff);
		double tmpDouble;
    	for ( i8bitImage=0 ; i8bitImage < size8bitImage ; i8bitImage++ )
    	{
			
			tmpDouble=(float)pChar[ i8bitImage ];
			tmpDouble=tmpDouble*slope+intercept;
			if (tmpDouble<0)
			{
				tmpDouble=0;
			} 
    		pShort[ i8bitImage ] = (unsigned short)tmpDouble;
    	}
    	free (pChar);
    }

// Y- Flip
	FlipY( getVolume( )->castVtk() );
	
}




// -------------------------------------------------------------------------
void marRAW2Files::FlipY(vtkImageData *imagedata)
{
	vtkImageData *vtkimagedata = imagedata;
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	vtkimagedata->Update();
#else
  //...
#endif
	int dim[3];
	vtkimagedata->GetDimensions(dim);
	unsigned short tmp;
	unsigned short *pp=(unsigned short*)vtkimagedata->GetScalarPointer(0,0,0);
	int xx,yy,zz;
	int sizeX  = dim[0];
	int sizeY  = dim[1];
	int sizeY2 = sizeY/2;
	int sizeZ  = dim[2];
	long int deltaZ;
	long int deltaA;
	long int deltaB;

	for ( zz=0 ; zz<sizeZ ; zz++ )
	{
		deltaZ=zz*sizeX*sizeY;
		for ( xx=0 ; xx<sizeX ; xx++ )
		{
		for ( yy=0 ; yy<sizeY2 ; yy++ )
			{
				deltaA		= xx + yy*sizeX + deltaZ;
				deltaB		= xx + (sizeY-yy-1)*sizeX + deltaZ;
				tmp			= pp[deltaA ];
				pp[deltaA]	= pp[deltaB ];
				pp[deltaB]	= tmp;
				}
			}
		}
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
   vtkimagedata->Update();
#else
   vtkimagedata->Modified();
#endif

}
// -------------------------------------------------------------------------

// EED 23 Janvier 2007
void marRAW2Files::saveVolume( std::string directory, std::string name, vtkImageData *imagedata,int voi[6], double slope, double intercept) // virtual
{

	std::string filename		 = directory+"/"+name;

		// Crop
	vtkExtractVOI *crop = vtkExtractVOI::New();

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	crop->SetInput( imagedata );
#else
	crop->SetInputData( imagedata );
#endif
	crop->SetVOI( voi );
	crop->Update();

	int dim[3];
	int ext[6];
	double spc[3];
	crop->GetOutput()->GetDimensions(dim);
	crop->GetOutput()->GetSpacing(spc);
	crop->GetOutput()->GetExtent(ext);


	vtkImageChangeInformation* change = vtkImageChangeInformation::New();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	change->SetInput( crop->GetOutput() );
#else
	change->SetInputData( crop->GetOutput() );
#endif


//	change->SetExtentTranslation( -ext[0], -ext[2], -ext[4] );
   

	change->SetOutputSpacing ( spc[0] , spc[1] , spc[2] );
	change->Update();    //important

//   change->SetExtentTranslation( ext[0], ext[2], ext[4] );
//	change->Update();


	// write mdh file
   std::string nameMW		 = filename+".mhd";

	vtkMetaImageWriter *writer = vtkMetaImageWriter::New( );

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	writer->SetInput( change->GetOutput() );
#else
	writer->SetInputData( change->GetOutput() );
#endif

	writer->SetFileName( nameMW.c_str() );
	writer->SetFileDimensionality( 3 );
	writer->Write( );

		// write maracas file
	std::string nameM=filename+".maracas";


	FILE *ff;
	ff=fopen(nameM.c_str(),"w");
		fprintf(ff,"MaracasType 200\n" );
		fprintf(ff,"sizeX %d\n",dim[0] );
		fprintf(ff,"sizeY %d\n",dim[1] );
		fprintf(ff,"sizeZ1 %d\n",0 );
		fprintf(ff,"sizeZ2 %d\n",dim[2] );
		fprintf(ff,"spcX %f\n",spc[0]  );
		fprintf(ff,"spcY %f\n",spc[1]  );
		fprintf(ff,"spcZ %f\n",spc[2]  );
		fprintf(ff,"intercept %f\n",intercept );
		fprintf(ff,"slope %f\n",slope );
		fprintf(ff,"LB %d\n",0 );
		fprintf(ff,"bits %d\n",16 );
		fprintf(ff,"%s.raw\n", name.c_str() );
	fclose(ff);

	writer	-> Delete();
	change	-> Delete();
	crop	-> Delete();
}

