/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */



#ifndef __MAR__KERNEL__MARDICOMBASE__HXX__
#define __MAR__KERNEL__MARDICOMBASE__HXX__



#include <wx/gauge.h>

#include "marObject.h"
#include "volume.hxx"


#include <vector>
#include <string>
//using namespace std;





class marFilesBase : public marObject{
public:
						marFilesBase(marParameters* p);
	virtual				~marFilesBase();
	virtual	wxString	GetPatientName() {return _T(""); };
			kVolume*	getVolume( );
			void		SetVolume( kVolume* volume  );
			bool		volumeLoaded( );
			void		freeVolume( );

	virtual void		loadActualSerie( wxGauge* gauge) {} ;
	virtual bool		loadImage(int i) {return true; };
	std::vector < std::string*>  *GetListImages();
			void		CleanListImages();

	void				ResetLstFileNotReaded();
	std::string			GetMsgLstFile();

private:
	kVolume						*_volume;

protected:
	std::vector < std::string*>	_lstString;
	std::vector < char*>		_lstFileNotReaded; 

};



//-------------------------------------------------------------------

class marRAWFiles : public marFilesBase
{
public:
	marRAWFiles(marParameters* p = NULL);
	~marRAWFiles();
	virtual bool	loadImage(int i);
	virtual void	loadActualSerie(wxGauge* gauge );
			void	SetLittreEndianBigEndian(int value);
			int		GetLittreEndianBigEndian();

    void reset( );
    void copyFrom( const marObject& from );
    bool save( std::ofstream& os );
    bool load( std::ifstream& is );


private:
	int _littreEndianBigEndian;
protected:
};


//-------------------------------------------------------------------
class marRAW2Files : public marRAWFiles
{
public:
	marRAW2Files(marParameters* p = NULL);
	~marRAW2Files();
	virtual bool loadImage(int i);
	virtual void loadActualSerie(wxGauge* gauge );
	virtual void saveVolume( std::string directory, std::string filename, vtkImageData *vtkimagedata,int voi[6], double slope, double intercept);
			void FlipY(vtkImageData *imagedata);

private:
protected:
};


//-------------------------------------------------------------------
class marRAW2AsciiFiles : public marRAWFiles
{
public:
	marRAW2AsciiFiles(marParameters* p = NULL);
	~marRAW2AsciiFiles();
	virtual bool loadImage(int i);
	virtual void loadActualSerie(wxGauge* gauge );

private:
protected:
};






#endif // __MAR__KERNEL__MARDICOMBASE__HXX__

