/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: marDynData.cpp,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:16:12 $
  Version:   $Revision: 1.4 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#include <vtkImageResample.h>
#include <vtkExtractVOI.h>
#include <vtkImageData.h>
#include <vtkImageChangeInformation.h>
#include <vtkImageShiftScale.h> 
#include <vtkImageThreshold.h> 
#include "marDynData.h"

// -------------------------------------------------------------------------
marDynData::marDynData( marParameters* p ) : marObject( p ), _volume( NULL )
{
	_marimagedata = new marImageData(NULL); 
}

// -------------------------------------------------------------------------
marDynData::~marDynData() 
{
//	_marimagedata->SetImageData(NULL);
	delete _marimagedata;
	reset( );
}
// -------------------------------------------------------------------------

void marDynData::loadData( kVolume* vol, int* voi )
 {
   int ext[6];
   reset( );
 
   vtkExtractVOI *crop = vtkExtractVOI::New();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
   crop->SetInput( vol->castVtk( ) );
#else
   crop->SetInputData( vol->castVtk( ) );
#endif

   crop->SetVOI( voi );
   //crop->SetSampleRate( getParameters( )->getVoxelSize( ), getParameters( )->getVoxelSize( ), getParameters( )->getVoxelSize( ));
   
   float RescalaSlope		=  getParameters()->getRescaleSlope();
   float RescalaIntercept	=  getParameters()->getRescaleIntercept();

//EED
//	RescalaSlope		= 1;
//	RescalaIntercept	= 0;

   vtkImageShiftScale *scale = vtkImageShiftScale::New();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
   scale->SetInput( crop->GetOutput( ) );
#else
   scale->SetInputData( crop->GetOutput( ) );
#endif
   scale->SetScale(RescalaSlope);
   scale->SetShift(0);
   scale->SetOutputScalarTypeToShort();
   scale->Update();
   vtkImageShiftScale *shift = vtkImageShiftScale::New();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
   shift->SetInput( scale->GetOutput( ) );
#else
   shift->SetInputData( scale->GetOutput( ) );
#endif
   shift->SetScale(1); 
   shift->SetShift(RescalaIntercept);
   shift->SetOutputScalarTypeToShort();
   shift->Update();


   vtkImageThreshold *threshold = vtkImageThreshold::New();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
   threshold->SetInput( shift->GetOutput( ) );
#else
   threshold->SetInputData( shift->GetOutput( ) );
#endif
   threshold->ThresholdByUpper (-10000); 
   threshold->ThresholdByLower (-1); 
   threshold->SetInValue(0);   
   threshold->ReplaceOutOff ();
   threshold->ReplaceInOn ();
   threshold->SetOutputScalarTypeToUnsignedShort();
   
   vtkImageResample* ir = vtkImageResample::New( );
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
   ir->SetInput( threshold->GetOutput( ) );
#else
   ir->SetInputData( threshold->GetOutput( ) );
#endif
   ir->SetDimensionality( 3 );
   double voxelSize= getParameters( )->getVoxelSize( );
   ir->SetAxisOutputSpacing( 0, voxelSize );
   ir->SetAxisOutputSpacing( 1, voxelSize );
   ir->SetAxisOutputSpacing( 2, voxelSize );


//	ir->SetAxisMagnificationFactor(0,1/getParameters( )->getVoxelSize( )); 

//EEDx1
   ir->InterpolateOn( );
//   ir->InterpolateOff( );


   ir->Update( );    //important
   ir->GetOutput()->GetExtent( ext );
 
  /**
   * Before we were using kgfoCrop which assume extent start at 0,0,0
   */
   vtkImageChangeInformation* change = vtkImageChangeInformation::New();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
   change->SetInput( ir->GetOutput() );
#else
   change->SetInputData( ir->GetOutput() );
#endif

   change->SetExtentTranslation( -ext[0], -ext[2], -ext[4] );
   change->SetOutputSpacing ( voxelSize , voxelSize , voxelSize );
   change->Update();    //important
 
   _volume = new kVolume( change->GetOutput( ) );

	_marimagedata->AddImageData( _volume->castVtk() );
	double spc[3];
	vol->castVtk()->GetSpacing(spc);
	_marimagedata->SetSpcOriginal( spc );
	_marimagedata->SetVoiOriginal(voi);


   crop		-> Delete();
   ir		-> Delete();
   change	-> Delete();
   shift	-> Delete();
   scale	-> Delete();
   threshold-> Delete();
 }


// -------------------------------------------------------------------------
void marDynData::reset( )
{
  //Efface car _volume est juste un pointeur ver _volume de marGdcmDicom qui
  //est detruit par le reset correspondant
// PS ->   #ifndef DXMM
// PS ->   if( _volume ) delete _volume;
// PS ->   #endif
  _volume = NULL;
}

// -------------------------------------------------------------------------
void marDynData::copyFrom( const marObject& from )
{
  reset( );
  _volume = new kVolume( *( ( ( marDynData& )from )._volume ) );
}

// -------------------------------------------------------------------------
bool marDynData::save( std::ofstream& os )
{
    void* data = _volume->getData1D( );
    uint32_t dims[ 3 ];
    ulong dSize = _volume->getRawSizeInBytes( );  // How many bytes for a 'ulong'? // JPR
    double sizes[ 3 ];
    kVolume::Type type = _volume->getType( );

    dims[ 0 ] = _volume->getXdim( );
    dims[ 1 ] = _volume->getYdim( );
    dims[ 2 ] = _volume->getZdim( );
    sizes[ 0 ] = _volume->getXsize( );
    sizes[ 1 ] = _volume->getYsize( );
    sizes[ 2 ] = _volume->getZsize( );

    os.write( ( const char* )dims, 3 * sizeof( uint32_t ) );
    os.write( ( const char* )sizes, 3 * sizeof( double ) );
    os.write( ( const char* )&type, sizeof( kVolume::Type ) );
    os.write( ( const char* )&dSize, sizeof( ulong ) );
    os.write( ( const char* )data, dSize );

    return( true );
}

// -------------------------------------------------------------------------
bool marDynData::load( std::ifstream& is )
{
    uint8_t* data;
    uint32_t dims[ 3 ];
    ulong dSize;
    double sizes[ 3 ];
    kVolume::Type type;

    reset( );

    is.read( ( char* )dims, 3 * sizeof( uint32_t ) );
    is.read( ( char* )sizes, 3 * sizeof( double ) );
    is.read( ( char* )&type, sizeof( kVolume::Type ) );
    is.read( ( char* )&dSize, sizeof( ulong ) );
    data = new uint8_t[ dSize ];
    is.read( ( char* )data, dSize );
	
    _volume = new kVolume( type, dims, sizes, ( void* )data );
	
    //cleaning
    delete[] data;

    return( true );
}

// ----------------------------------------------------------------------------------------------
marImageData *marDynData::GetMarImageData()
{
	return _marimagedata;
}
// ----------------------------------------------------------------------------------------------

// eof - dynData.cxx
