/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================


=========================================================================*/
#include "marImageData.h"

// ----------------------------------------------------------------------------------------------
marImageData::marImageData(vtkImageData *imagedata)
{
	_spcOriginal[0] = 1;
	_spcOriginal[1] = 1;
	_spcOriginal[2] = 1;
	_voiOriginal[0] = 0;
	_voiOriginal[1] = 0;
	_voiOriginal[2] = 0;
	_voiOriginal[3] = 0;
	_voiOriginal[4] = 0;
	_voiOriginal[5] = 0;
	if(imagedata!=NULL){
		AddImageData(imagedata);
	}
}
// ----------------------------------------------------------------------------------------------
marImageData::~marImageData()
{
	int i,size=_imagedataLST.size();
	for (i=0;i<size;i++)
	{
	//	_imagedataLST[i]->Delete();
	}
	_imagedataLST.clear();
}

// ----------------------------------------------------------------------------------------------
void marImageData::SetSpcOriginal(double spc[3])
{
	this->_spcOriginal[0]=spc[0];
	this->_spcOriginal[1]=spc[1];
	this->_spcOriginal[2]=spc[2];
}
// ----------------------------------------------------------------------------------------------
void marImageData::SetVoiOriginal(int voi[6])
{
	int i;
	for (i=0;i<6;i++)
	{
		this->_voiOriginal[i] = voi[i];
	}
}
// ----------------------------------------------------------------------------------------------
void marImageData::AddImageData(vtkImageData *imagedata)
{
	if (imagedata!=NULL){
		_imagedataLST.push_back( imagedata );
	}
}
// ----------------------------------------------------------------------------------------------
void marImageData::GetSpcOriginal(double spc[3])
{
	spc[0] = this->_spcOriginal[0];
	spc[1] = this->_spcOriginal[1];
	spc[2] = this->_spcOriginal[2];
}
// ----------------------------------------------------------------------------------------------
void marImageData::GetVoiOriginal(int voi[6])
{
	int i;
	for (i=0;i<6;i++)
	{
		voi[i] = this->_voiOriginal[i];
	}
}
// ----------------------------------------------------------------------------------------------
vtkImageData *marImageData::GetImageDataT(int t)
{
	if(_imagedataLST.size() > t){
		return _imagedataLST[t];
	}
	return NULL;
}
// ----------------------------------------------------------------------------------------------
vtkImageData *marImageData::GetImageData()
{
	if(_imagedataLST.size()>0){
		return _imagedataLST[0];
	}
	return NULL;
}

void marImageData::removeImageData(int index)
{
	if(index < _imagedataLST.size())
	{

		/*vtkImageData* img = _imagedataLST[index];
		if(img->GetReferenceCount()>1){
			img->SetReferenceCount(img->GetReferenceCount()-1);
			//img->Delete();
		}*/
		for(int i = index; i < _imagedataLST.size()-1; i++)
		{			
			_imagedataLST[i] = _imagedataLST[i+1];
		}// for
		_imagedataLST.pop_back();
		//delete img;
	} // if	
}
// ----------------------------------------------------------------------------------------------
int marImageData::GetXOriginal(int value)
{
	double min=_spcOriginal[0];
	if (_spcOriginal[1]<min)
	{
		min = _spcOriginal[1];
	}
	if (_spcOriginal[2]<min)
	{
		min = _spcOriginal[2];
	}
	double result = value / (  _spcOriginal[0] / min ) ;
	result=result + _voiOriginal[0];
	return (int)result;
}
// ----------------------------------------------------------------------------------------------
int marImageData::GetYOriginal(int value)
{
	double min=_spcOriginal[0];
	if (_spcOriginal[1]<min)
	{
		min = _spcOriginal[1];
	}
	if (_spcOriginal[2]<min)
	{
		min = _spcOriginal[2];
	}
	double result = value / (  _spcOriginal[1] / min ) ;
	result=result + _voiOriginal[2];
	return (int)result;
}
// ----------------------------------------------------------------------------------------------
int marImageData::GetZOriginal(int value)
{
	double min=_spcOriginal[0];
	if (_spcOriginal[1]<min)
	{
		min = _spcOriginal[1];
	}
	if (_spcOriginal[2]<min)
	{
		min = _spcOriginal[2];
	}
	double result = value / (  _spcOriginal[2] / min ) ;
	result=result + _voiOriginal[4];
	return (int)result;
}
// ----------------------------------------------------------------------------------------------
int marImageData::GetMaxT()
{
	return _imagedataLST.size();
}
