/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: marObject.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:16:12 $
  Version:   $Revision: 1.6 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#ifndef __MAR__KERNEL__OBJECT__HXX__
#define __MAR__KERNEL__OBJECT__HXX__

#include <string>
#include "marTypes.h"
#include "marParameters.h"

/** /def marObject
 *  \brief General maracas object.
 */
class creaMaracasVisu_EXPORT marObject
{
    public:

    /** Default constructor.
     */
    marObject( marParameters* p );

    /** Default destructor.
     */
    virtual ~marObject( );

    /** Parameters assignation methods.
     *
     *  You can assign a marParameters object by reference (setParameters)
     *  or by value (copyParameters).
     *  Besides, if you want to make your actual reference to be by value,
     *  call makeACopyParameters.
     */
    void setParameters( marParameters* p );
    void copyParameters( marParameters* p );
    void makeACopyParameters( )
    {
	    copyParameters( _parameters );
    }

    /** Parameters analizers.
     */
    marParameters* getParameters( ) { return( _parameters ); };
    bool parametersOwned( ) { return( _parametersCopied ); };

    /** Virtual general methods
     *  (must be defined in each sub-class).
     */
    virtual void reset( ) = 0;
    virtual void copyFrom( const marObject& from ) = 0;

    /** Virtual persistence methods
     *  (must be defined in each sub-class).
     */
    virtual bool save( std::ofstream& os ) = 0;
    virtual bool load( std::ifstream& is ) = 0;

    /** Persistence methods
     */
    bool save( std::string& nw );
    bool load( std::string& nr );

    private:

    marParameters* _parameters;
    bool _parametersCopied;

};

#endif // __MAR__KERNEL__OBJECT__HXX__

// eof - marObject.h
