/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

 Program:   wxMaracas
 Module:    $RCSfile: marParameters.cpp,v $
 Language:  C++
 Date:      $Date: 2012/11/15 14:16:12 $
 Version:   $Revision: 1.4 $
 
  Copyright: (c) 2002, 2003
  License:
  
   This software is distributed WITHOUT ANY WARRANTY; without even 
   the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
   PURPOSE.  See the above copyright notice for more information.
   
=========================================================================*/

#include "marParameters.h"
#include <math.h>
#include <wx/log.h>

static const char* BoolParamNames[] = {
	// PS ->     "e_debug_window_visible"  ,
	// PS -> 	"e_debug_console_visible"     ,
	// PS -> 	"e_calculate_mip_default"    ,
	// PS -> 	"e_choose_all_slices_default" ,
	"e_debug_isocontour"          ,
	"e_debug_diameters"           ,
	"e_debug_fill_area"           ,
	"e_invest_slice_order"           ,
	// PS -> 	"e_show_cell"                 ,
	// PS -> 	"e_show_int_cell"
};

static const char* DoubleParamNames[] = {
    "e_gravity_distance"              ,
	"e_axis_discret_step"             ,
	"e_distance_to_maximum_intensity" ,
	"e_cell_coeficient"               ,
	"e_flexion_coeficient"            ,
	"e_tension_coeficient"            ,
	"e_voxel_x_dimension"            ,
	"e_voxel_y_dimension"             ,
	"e_voxel_z_dimension"             ,
	"e_scale"                         ,
	// PS -> 	"e_sampling"                      ,
	"e_threshold_isocontour"          ,
	"e_threshold_snake_isocontour"    ,
	"e_sigma"                         ,
	// PS -> 	"e_gradient_coeficient"           ,
	// PS -> 	"e_extern_coeficient"             ,
	// PS -> 	"e_ballon_coeficient"             ,
	// PS -> 	"e_back_color_3D_r"               ,
	// PS -> 	"e_back_color_3D_g"               ,
	// PS -> 	"e_back_color_3D_b"               ,
	// PS -> 	"e_axis_color_r"                  ,
	// PS -> 	"e_axis_color_g"                  ,
	// PS -> 	"e_axis_color_b"
    "e_RescaleIntercept"          ,
    "e_RescaleSlope"              ,
};

static const char* IntParamNames[] = {
    "e_roi_dimension"                     ,
	"e_step"                                  ,
	"e_step_coeficient"                       ,
	"e_mass_power"                            ,
	"e_algorithm_type"                        ,
	"e_mask_size"                             ,
	"e_number_of_points_for_snake"            ,
	"e_quantification_type"                   ,
	"e_stenosis_type"                         ,
	// PS -> 	"e_number_of_iterations_snake_isocontour" ,
	// PS -> 	"e_number_of_iterations_snake_deriche"    ,
	"e_voxel_type"                            ,
	// PS -> 	"e_coef_cell_max_int"
};

static const char* StringParamNames[] = {
	"e_installation_directory" ,
	"e_dicom_images_directory"
};

// -------------------------------------------------------------------------
double marParameters::getVoxelSize( )
{
/* OLD CODE:

 double ret = 1.0;
 
  if( _intValues[ e_voxel_type ] == VOX_TYPE_MINIMUM ) {
  
   ret = _doubleValues[ e_voxel_x_dimension ];
   ret = GTM_MIN( _doubleValues[ e_voxel_y_dimension ], ret );
   ret = GTM_MIN( _doubleValues[ e_voxel_z_dimension ], ret );
   
    } // fi
    return( ret );
	*/


//EEDx1	
    double ret = 1.0;
    //Juan Carrillo 03/06/2005
	if( _intValues[ e_voxel_type ] == VOX_TYPE_MINIMUM ) {
		
		ret = _doubleValues[ e_voxel_x_dimension ];
		ret = ( _doubleValues[ e_voxel_y_dimension ] < ret )?
			_doubleValues[ e_voxel_y_dimension ]: ret;
		ret = ( _doubleValues[ e_voxel_z_dimension ] < ret )?
			_doubleValues[ e_voxel_z_dimension ]: ret;
    } // fi
    return( ret*1 );
}

// -------------------------------------------------------------------------
double marParameters::getDimIma( )
{
	double scale = _doubleValues[ e_scale ];
	double roiDim = ( double )( _intValues[ e_roi_dimension ] );
    return( scale * roiDim );
}

// -------------------------------------------------------------------------
int marParameters::getSizeIma( )
{
    //  TODO : There should be a formal way to calculate a good image size.
    return( 128 ); 
}

// -------------------------------------------------------------------------
double marParameters::getImaRatio( )
{
    return( getDimIma( ) / ( double )( getSizeIma( ) ) );
}

// -------------------------------------------------------------------------
void marParameters::setROIStep( double width )
{
    _intValues[ e_roi_dimension ] =
		( int )ceil( _doubleValues[ e_cell_coeficient ] * width );
    _intValues[ e_step ] =
		( int )floor( ( double )_intValues[ e_roi_dimension ] /
		      ( double )_intValues[ e_step_coeficient ] );
}


// -------------------------------------------------------------------------
float marParameters::getRescaleSlope(){
	return (float) _doubleValues[ e_RescaleSlope ];
}
// -------------------------------------------------------------------------
float marParameters::getRescaleIntercept(){
	return (float) _doubleValues[ e_RescaleIntercept ];
}
// -------------------------------------------------------------------------
void marParameters::setRescaleSlope(float slope){
	_doubleValues[ e_RescaleSlope ]= slope;
}
// -------------------------------------------------------------------------
void marParameters::setRescaleIntercept(float intercept){
	_doubleValues[ e_RescaleIntercept ]= intercept;
}
// -------------------------------------------------------------------------
void marParameters::copyFrom( const marParameters& from )
{
    int i;
	
    memcpy( _boolValues, from._boolValues, e_bool_cont * sizeof( bool ) );
    memcpy( _intValues, from._intValues, e_int_cont * sizeof( int ) );
    memcpy( _doubleValues,
		from._doubleValues,
		e_double_cont * sizeof( double ) );
	
     for( i = 0; i < e_string_cont; i++ )
 		_stringValues[ i ] = from._stringValues[ i ];
}

// -------------------------------------------------------------------------
void marParameters::reset( )
{
	// PS ->     _boolValues[ e_debug_window_visible ]      = false;
	// PS ->     _boolValues[ e_debug_console_visible ]     = false;
	// PS ->     _boolValues[ e_calculate_mip_default ]     = false;
	// PS ->     _boolValues[ e_choose_all_slices_default ] = true;
    _boolValues[ e_debug_isocontour ]          = true;
    _boolValues[ e_debug_diameters ]           = true;
    _boolValues[ e_debug_fill_area ]           = false;
    _boolValues[ e_invest_slice_order ]		   = false;
	// PS ->     _boolValues[ e_show_cell ]                 = true;
	// PS ->     _boolValues[ e_show_int_cell ]             = true;
	
    _doubleValues[ e_gravity_distance ]              = 1.0;
    _doubleValues[ e_axis_discret_step ]             = 2.0;
    _doubleValues[ e_distance_to_maximum_intensity ] = 0.0;
    _doubleValues[ e_cell_coeficient ]               = 1.2;
    _doubleValues[ e_flexion_coeficient ]            = 0.1;
    _doubleValues[ e_tension_coeficient ]            = 0.3;
    _doubleValues[ e_voxel_x_dimension ]             = 1.0;
    _doubleValues[ e_voxel_y_dimension ]             = 1.0;
    _doubleValues[ e_voxel_z_dimension ]             = 1.0;
    _doubleValues[ e_scale ]                         = 4.0;
	// PS ->     _doubleValues[ e_sampling ]         = 4.0;
    _doubleValues[ e_threshold_isocontour ]          = 40.0;
    _doubleValues[ e_threshold_snake_isocontour ]    = 40.0;
    _doubleValues[ e_sigma ]                         = 0.1;
    _doubleValues[ e_RescaleIntercept ]              = 0;
    _doubleValues[ e_RescaleSlope ]                  = 1;
	// PS ->     _doubleValues[ e_extern_coeficient ]             = 0.3;
	// PS ->     _doubleValues[ e_gradient_coeficient ]           = 0.3;
	// PS ->     _doubleValues[ e_ballon_coeficient ]             = 0.02;
	// PS ->     _doubleValues[ e_back_color_3D_r ]               = 0.0;
	// PS ->     _doubleValues[ e_back_color_3D_g ]               = 0.0;
	// PS ->     _doubleValues[ e_back_color_3D_b ]               = 0.0;
	// PS ->     _doubleValues[ e_axis_color_r ]                  = 1.0;
	// PS ->     _doubleValues[ e_axis_color_g ]                  = 0.0;
	// PS ->     _doubleValues[ e_axis_color_b ]                  = 0.0;
	
	
    _intValues[ e_roi_dimension ]                         = 10;
    _intValues[ e_step ]                                  = 3;
    _intValues[ e_step_coeficient ]                       = 2;
    _intValues[ e_mass_power ]                            = 2;
    _intValues[ e_algorithm_type ]                        = ISOCONTOURS;
    _intValues[ e_mask_size ]                             = 5;
    _intValues[ e_number_of_points_for_snake ]            = 20;
    _intValues[ e_quantification_type ]                   = TYPE_AREA;
    _intValues[ e_stenosis_type ]                         = TYPE_AREA;
	// PS ->     _intValues[ e_number_of_iterations_snake_isocontour ] = 5;
	// PS ->     _intValues[ e_number_of_iterations_snake_deriche ]    = 700;


    _intValues[ e_voxel_type ]                            = VOX_TYPE_NORMAL;


	// PS ->     _intValues[ e_coef_cell_max_int ]                     = 2;
	
     _stringValues[ e_installation_directory ]  = _T("NO_DIRECTORY");
     _stringValues[ e_dicom_images_directory ] = _T("NO_DIRECTORY");
	
	 //MAZV CT compatibility
	_contourThresh 		= 10;
	_lumenPercentage 	= 86;
	_calcPercentage 	= 90;
	_standardDeviation 	= 3;
	_radius 		= 3;
	//end MAZV CT compatibility

}

// -------------------------------------------------------------------------
bool marParameters::save( std::ofstream& os )
{
    int i, s;
	try 
	{
		os.write( ( const char* )_boolValues, e_bool_cont * sizeof( bool ) );
		os.write( ( char* )_intValues, e_int_cont * sizeof( int ) );
		os.write( ( const char* )_doubleValues, e_double_cont * sizeof( double ) );
 		for( i = 0; i < e_string_cont; i++ ) {
 			s = _stringValues[ i ].length( );
 			os.write( ( const char* )&s, sizeof( int ) );
 			os.write( ( const char* )_stringValues[ i ].c_str( ), s * sizeof( char ) );
 		} // rof
		return( true );
	}
	catch (...)
	{
		return(false);
	}
    
}

// -------------------------------------------------------------------------
bool marParameters::load( std::ifstream& is )
{
	int i, s;
	try
	{
		char tmp[500];
		is.read( ( char* )_boolValues, e_bool_cont * sizeof( bool ) );
		is.read( ( char* )_intValues, e_int_cont * sizeof( int ) );
		is.read( ( char* )_doubleValues, e_double_cont * sizeof( double ) );
 		for( i = 0; i < e_string_cont; i++ )
 		{
 			is.read( ( char* )&s, sizeof( int ) );
 			_stringValues[ i ].resize( s );
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
 			is.read( ( char* )_stringValues[ i ].c_str( ), s * sizeof( char ) );
#else
 			is.read( tmp , s * sizeof( char ) );
			_stringValues[ i ]=wxString(tmp);
#endif
 		} // rof
		return( true );	
	}
	catch (...)
	{
		
		return(false);
	}
	
}

// -------------------------------------------------------------------------
bool marParameters::save( wxString& nw )
{
    std::ofstream os( (const char*)nw.mb_str( ) ,std::ios::out |std::ios::binary );
	
//EEDxx2.4 DEBuG
//	wxLogDebug("Saving parameters to file " + nw);

//EED2016-12-22	
//    if( os==NULL ) 
    if( os.is_open()==false ) 
	{
		wxString errorMsg;
		errorMsg= _T("Error : Cannot open file ")+nw+_T(" to save parameters");
//EEDxx2.4 DEBuG
//		wxLogDebug(errorMsg);
		return( false );
	}
	if (save( os ))
	{
		os.close( );
//EEDxx2.4 DEBuG
//		wxLogDebug("Parameters saved to file " + nw);
		return( true );
	}
	else
	{
		os.close( );
//EEDxx2.4 DEBuG
//		wxLogDebug("Error : Cannot save parameters to file "+nw);
		return(false);
	}
}

// -------------------------------------------------------------------------
bool marParameters::load( wxString& nr )
{
    std::ifstream is( (const char*)nr.mb_str( ),std::ios::binary|std::ios::in);
	
//EEDxx2.4 DEBuG
//	wxLogDebug("Laoding parameters from file " + nr);

//EED 2016-12-22
//    if( is==NULL ) 
    if( is.is_open()==false ) 
	{
		wxString errorMsg;
		errorMsg= _T("Error : Cannot open file ")+nr+_T(" to load parameters");
//EEDxx2.4 DEBuG
//		wxLogDebug(errorMsg);
		return( false );
	}
	if (load( is ))
	{
		is.close( );
//EEDxx2.4 DEBuG
//		wxLogDebug("Parameters loaded from file " + nr);
		return( true );
	}
	else
	{
		is.close( );
//EEDxx2.4 DEBuG
//		wxLogDebug("Error : Cannot load parameters from file "+nr+": file may be corrupted");
		return(false);
	}
}

// ----------------------------------------------------------------------------
wxArrayString marParameters::getRelationalArray( )
{
    // Allocate memory for pairs of data plus one end NULL array
	//    wxStringList ret;
    wxArrayString ret;
    wxString str;
    int i, j;
	
    for( i = 0, j = 0; i < e_bool_cont; i++, j += 2 ) {
		
		ret.Add( wxString( BoolParamNames[ i ], wxConvUTF8)  );
		str.Printf( _T("%d"), ( _boolValues[ i ] )? 1: 0 );
		ret.Add( str );
		
    } // rof
    for( i = 0; i < e_double_cont; i++, j += 2 ) {
		
		ret.Add( wxString( DoubleParamNames[ i ], wxConvUTF8)  );
		str.Printf( _T("%f"), _doubleValues[ i ] );
		ret.Add( str );
		
    } // rof
    for( i = 0; i < e_int_cont; i++, j += 2 ) {
		
		ret.Add( wxString( IntParamNames[ i ], wxConvUTF8) );
		str.Printf( _T("%d"), _intValues[ i ] );
		ret.Add( str );
		
    } // rof

     for( i = 0; i < e_string_cont; i++, j += 2 ) {
 		ret.Add( wxString( StringParamNames[ i ], wxConvUTF8)  );
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
 		ret.Add( wxString( _stringValues[ i ].c_str( ), wxConvUTF8 ) );
#else
 		ret.Add( wxString( _stringValues[ i ] ) );
#endif
     } // rof


    return( ret );
	
}

// ----------------------------------------------------------------------------
//void marParameters::setRelationalArray( wxStringList& arr )
void marParameters::setRelationalArray( wxArrayString& arr )
{
	
    int i = 0, j;
    bool cont;
	
	//    while( arr[ i ] != NULL ) {
    while( !arr.IsEmpty() ) {
		
		cont = true;
 		for( j = 0; j < e_string_cont && cont; j++ ) {
   			if( strcmp( StringParamNames[ j ], (const char*)arr[ i ].mb_str() ) == 0 ) {
  				_stringValues[ j ] = ( wxString )arr[ i + 1 ];
  				cont = false;
  			} // fi
		} // rof
		for( j = 0; j < e_bool_cont && cont; j++ ) {
			
			if( strcmp( BoolParamNames[ j ], (const char*)arr[ i ].mb_str() ) == 0 ) {
				
				_boolValues[ j ] = ( strcmp( (const char*)arr[ i + 1 ].mb_str(), "1" ) == 0 );
				cont = false;
				
			} // fi
			
		} // rof
		for( j = 0; j < e_int_cont && cont; j++ ) {
			
			if( strcmp( IntParamNames[ j ], (const char*)arr[ i ].mb_str() ) == 0 ) {
				
				_intValues[ j ] = atoi( (const char*)arr[ i + 1 ].mb_str() );
				cont = false;
				
			} // fi
			
		} // rof
		for( j = 0; j < e_double_cont && cont; j++ ) {
			
			if( strcmp( DoubleParamNames[ j ], (const char*)arr[ i ].mb_str() ) == 0 ) {
				
				( ( wxString )arr[ i + 1 ] ).ToDouble( &_doubleValues[ j ] );
				cont = false;
				
			} // fi
			
		} // rof
		i += 2;
		
    } // fwhile
	
}


bool marParameters::getInvestSliceOrder(){
  return _boolValues[ e_invest_slice_order ];
}

//MAZV - Added for CT compatibility
// ----------------------------------------------------------------------------
int marParameters::getContourThresh() {
	return _contourThresh;
}

// ----------------------------------------------------------------------------
void marParameters::setContourThresh( int thresh ) {
	_contourThresh = thresh;
}

// ----------------------------------------------------------------------------
double marParameters::getStandardDeviation() {
	return _standardDeviation;
}

// ----------------------------------------------------------------------------
double marParameters::getRadius() {
	return _radius;
}

// ----------------------------------------------------------------------------
void marParameters::setStandardDeviation( double dev ) {
	_standardDeviation = dev;
}

// ----------------------------------------------------------------------------
void marParameters::setRadius( double rad ) {
	_radius = rad;
}

// ----------------------------------------------------------------------------
void marParameters::setLumenPercentage(int percentage) {
	_lumenPercentage = percentage;
}
// ----------------------------------------------------------------------------
void marParameters::setCalcPercentage(int percentage) {
	_calcPercentage = percentage;
}

// ----------------------------------------------------------------------------
int	 marParameters::getLumenPercentage() {
	return _lumenPercentage;
}

// ----------------------------------------------------------------------------
int  marParameters::getCalcPercentage() {
	return _calcPercentage;
}
//MAZV end of addition
// eof - parameters.cxx
