/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: marTypes.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:16:12 $
  Version:   $Revision: 1.10 $

  Copyright: (c) 2002, 2003
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef __MAR__KERNEL__TYPES__HXX__
#define __MAR__KERNEL__TYPES__HXX__

/*! /def MAR_KERNEL_EXPORT
 *  \brief Library export type.
 *
 *  Use this constant to define your class, function or variable link type.
 *  Ex.: class MAR_KERNEL_EXPORT myClass { ... };
 *  This is defined by means of other constants:
 *       - MAR_KERNEL_MAKING_DLL (compilation of a dll).
 *       - MAR_KERNEL_USING_DLL  (linking, ie, using the dll).
 *  Note that if you want to build a static library, you should forget all
 *  this fairy tale :-).
 */

//JHCL - Start
//If we're using windows
/*
#if defined(WIN32)
	//If we're using a dynamic library
	#ifdef creaMaracasVisu_BUILD_SHARED
		#define MARACASVISULIB_EXPORTS __declspec( dllexport )
	#else
		#define MARACASVISULIB_EXPORTS __declspec( dllimport )
	#endif //maracasvisulib_EXPORTS
#else
	#define MARACASVISULIB_EXPORTS
#endif
	*/
// LG 15/01/09 : Now use crea mechanism
#include "creaMaracasVisu_EXPORT.h"
//JHCL - End


/*
#if defined(WIN32) //&& defined(MARACAS_BUILD_SHARED_LIBS)
# ifdef MaracasKernel_EXPORTS
#   define MAR_KERNEL_EXPORT __declspec( dllexport )
# else
#   define MAR_KERNEL_EXPORT //__declspec( dllimport )
# endif //MaracasKernel_EXPORTS

# ifdef MaracasInterfaceWX_EXPORTS
#   define MAR_INTERFACEWX_EXPORT __declspec( dllexport )
# else
#   define MAR_INTERFACEWX_EXPORT //__declspec( dllimport )
# endif //MaracasInterfaceWX_EXPORTS

#else

# define MAR_KERNEL_EXPORT
# define MAR_INTERFACEWX_EXPORT

#endif //WIN32
*/

// Other ridiculous constants and typedefs. Just for fun!
#define MAR_DEFAULT_FILE_PARAMETERS      "params.dat"
#define MAR_DEFAULT_FILE_DICTIONARY      "marDict.txt"
#define MAR_DEFAULT_FILE_EXT_EXPERIMENT  ".exp"


/*! \file kgfo_typ.hxx
 *  \brief General constants, types, enums, structs.
 *
 *  This file is included by all project files.
 */

#include "creaSystem.h"

// This redefinitions shoul be useless using uint8_t, etc  // JPR

typedef unsigned char  uchar;  /*!< unsigned char redefintion. */
typedef unsigned int   uint;   /*!< unsigned int redefintion. */
typedef unsigned long  ulong;  /*!< unsigned long redefintion. */
typedef unsigned short ushort; /*!< unsigned short redefintion. */

// Is this compilation using VTK?
#define KGFO_USE_VTK

#ifdef _MSC_VER
#pragma warning ( disable : 4018 )
// 'this' : used in base member initializer list ... so what !
#pragma warning ( disable : 4355 )
#endif //_MSC_VER

#endif // __MAR__KERNEL__TYPES__HXX__

// eof - marTypes.h
