/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#include "vtkSTLExtractor.h"
#include <vtkImageGaussianSmooth.h>
#include <vtkMarchingCubes.h>
#include <vtkCleanPolyData.h>
#include <vtkTriangleFilter.h>
#include <vtkImageContinuousDilate3D.h>


vtkSTLExtractor::vtkSTLExtractor(){
	innerSurface = vtkPolyData::New();
	outerSurface = vtkPolyData::New();
	marchingCubesLevel = 128.0;
	sigmaLevel = 100.0;
}

vtkSTLExtractor::~vtkSTLExtractor(){
	innerSurface->Delete();
	outerSurface->Delete();
}

void vtkSTLExtractor::setVolume(vtkImageData *volume){
	this->volume = volume;
}


void vtkSTLExtractor::setMarchingCubesLevel(double level){
	this->marchingCubesLevel = level;
}

void vtkSTLExtractor::setSigmaLevel(double level){
	this->sigmaLevel = level;
}


double vtkSTLExtractor::getMarchingCubesLevel(){
	return marchingCubesLevel;
}

double vtkSTLExtractor::getSigmaLevel(){
	return sigmaLevel;
}


vtkPolyData* vtkSTLExtractor::getInnerSurface(){
	return innerSurface;
}


vtkPolyData* vtkSTLExtractor::getOuterSurface(){
	return outerSurface;
}



void vtkSTLExtractor::calculate(){

	// ------------------------------------------------------------------------
		//  1. CALCULATING THE INNER SURFACE
		// ------------------------------------------------------------------------
	    vtkImageGaussianSmooth *gaussFilter = vtkImageGaussianSmooth::New();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
        gaussFilter->SetInput(volume);
#else
        gaussFilter->SetInputData(volume);
#endif
        gaussFilter->SetDimensionality(3);
    	gaussFilter->SetStandardDeviation(sigmaLevel);
    
        vtkMarchingCubes *cubesFilter = vtkMarchingCubes::New();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
        cubesFilter->SetInput(gaussFilter->GetOutput());
#else
        cubesFilter->SetInputData(gaussFilter->GetOutput());
#endif
        cubesFilter->SetValue(0,marchingCubesLevel);
		cubesFilter->ComputeGradientsOn ();
        cubesFilter->ComputeScalarsOn ();
		cubesFilter->SetNumberOfContours( 1 );
	    
		// Unir puntos duplicados y remover primitivas degeneradas
		vtkCleanPolyData *cleanFilter = vtkCleanPolyData::New();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
        cleanFilter->SetInput( cubesFilter->GetOutput() );
#else
        cleanFilter->SetInputData( cubesFilter->GetOutput() );
#endif
		
		// crea poligonos triangulares
        vtkTriangleFilter *triangleFilter = vtkTriangleFilter::New();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
        triangleFilter->SetInput( cleanFilter->GetOutput() );
#else
        triangleFilter->SetInputData( cleanFilter->GetOutput() );
#endif
        triangleFilter->Update();

		innerSurface->DeepCopy(triangleFilter->GetOutput());


		// ------------------------------------------------------------------------
		//  2. CALCULATING THE OUTER SURFACE
		// ------------------------------------------------------------------------
		vtkImageContinuousDilate3D *dilateFilter = vtkImageContinuousDilate3D ::New();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
        dilateFilter->SetInput(volume);
#else
        dilateFilter->SetInputData(volume);
#endif
		dilateFilter->SetKernelSize (3, 3, 3);
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		gaussFilter->SetInput( dilateFilter->GetOutput());
#else
		gaussFilter->SetInputData( dilateFilter->GetOutput());
#endif
        triangleFilter->Update();
		
	    outerSurface->DeepCopy(triangleFilter->GetOutput());

		// ------------------------------------------------------------------------
		//  3. CLEANING UP
		// ------------------------------------------------------------------------

		gaussFilter->Delete();
		cubesFilter->Delete();
		cleanFilter->Delete();
	    triangleFilter->Delete();
        dilateFilter->Delete();
}
