/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------   
*/


#ifndef __bbPackRecalageCheckBoardBox_h_INCLUDED__
#define __bbPackRecalageCheckBoardBox_h_INCLUDED__
#include "bbPackRecalage_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "vtkImageData.h"
#include "CheckBoard.h"
#include "iostream"

namespace bbPackRecalage
{

class bbPackRecalage_EXPORT CheckBoardBox
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(CheckBoardBox,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(In1, vtkImageData*);
  BBTK_DECLARE_INPUT(In2, vtkImageData*);
  BBTK_DECLARE_INPUT(Cols, int);
  BBTK_DECLARE_INPUT(Rows, int);
  BBTK_DECLARE_OUTPUT(Out, vtkImageData*);
  BBTK_PROCESS(Process);
  void Process();

  private:
		CheckBoard *checkboard;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(CheckBoardBox,bbtk::AtomicBlackBox);
BBTK_NAME("CheckBoardBox");
BBTK_AUTHOR("Carolina Perez/Ricardo A Corredor");
BBTK_DESCRIPTION("Produces a checkboard effect using the two images and thenumber of rows and columns.");
BBTK_CATEGORY("__CATEGORY__");
BBTK_INPUT(CheckBoardBox, In1, "Input Image1", vtkImageData*, "");
BBTK_INPUT(CheckBoardBox, In2, "Input Image2", vtkImageData*, "");
BBTK_INPUT(CheckBoardBox, Cols, "Number of partitions for the X axis (columns)", int, "");
BBTK_INPUT(CheckBoardBox, Rows, "Number of partitions for the Y axis (rows)", int, "");
BBTK_OUTPUT(CheckBoardBox, Out, "Output Image", vtkImageData*, "");
BBTK_END_DESCRIBE_BLACK_BOX(CheckBoardBox);
}
// EO namespace bbPackVisuImages

#endif // __bbPackVisuImagesCheckBoardBox_h_INCLUDED__

