/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------   
*/


#ifdef _USE_WXWIDGETS_
#ifndef __bbPackRecalageFileOpenSaveWidget_h_INCLUDED__
#define __bbPackRecalageFileOpenSaveWidget_h_INCLUDED__
#include "bbPackRecalage_EXPORT.h"
#include "bbtkWxBlackBox.h"

namespace bbPackRecalage
{

class bbPackRecalage_EXPORT FileOpenSaveWidget
 : 
   public bbtk::WxBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(FileOpenSaveWidget,bbtk::WxBlackBox);
  BBTK_DECLARE_INPUT(Title,std::string);
  BBTK_DECLARE_INPUT(In,std::string);
  BBTK_PROCESS(Process);
  void Process();
  BBTK_CREATE_WIDGET(CreateWidget);
  void CreateWidget(wxWindow*);
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(FileOpenSaveWidget,bbtk::WxBlackBox);
BBTK_NAME("FileOpenSaveWidget");
BBTK_AUTHOR("jn.trillos44@uniandes.edu.co");
BBTK_DESCRIPTION("A general Open and Save Widget that uses a file selector and writes and opens .xls files");
BBTK_CATEGORY("__CategoryBlackBox__");
BBTK_INPUT(FileOpenSaveWidget,Title,"Title prepended to the text",std::string,"");
BBTK_INPUT(FileOpenSaveWidget,In,"Text",std::string,"");
BBTK_END_DESCRIBE_BLACK_BOX(FileOpenSaveWidget);
}
// EO namespace bbPackRecalage

#endif // __bbPackRecalageFileOpenSaveWidget_h_INCLUDED__
#endif // _USE_WXWIDGETS_

