/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------   
*/


//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
#ifndef __bbPackRecalageGridOnImageGenerator_h_INCLUDED__
#define __bbPackRecalageGridOnImageGenerator_h_INCLUDED__
#include "bbPackRecalage_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

//VTK
#include "vtkImageData.h"

//OWN
#include "MyGridOnImageGenerator.h"

namespace bbPackRecalage
{

class bbPackRecalage_EXPORT GridOnImageGenerator
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(GridOnImageGenerator,bbtk::AtomicBlackBox);
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
  BBTK_DECLARE_INPUT(In,vtkImageData*);
  BBTK_DECLARE_INPUT(GridSpcX,double);
  BBTK_DECLARE_INPUT(GridSpcY,double);
  BBTK_DECLARE_INPUT(GridSpcZ,double);

  BBTK_DECLARE_OUTPUT(Out,vtkImageData*);

  BBTK_PROCESS(Process);
  void Process();
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//=====

private:

  //Grid on image generator attribute
  MyGridOnImageGenerator* gridOnImageGenerator;

};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(GridOnImageGenerator,bbtk::AtomicBlackBox);
BBTK_NAME("GridOnImageGenerator");
BBTK_AUTHOR("Alfredo Morales Pinzon, morales@creatis.insa-lyon.fr, write me if you have questions :) N'hésitez pas");
BBTK_DESCRIPTION("Box that creates an grid over an image. This is usually used to visualized the deformation that takes place over an image after a transformation, specially when non-rigid registration is applied. In order to create the grid the user must specify the spacing in each direction using the image coordinates, for example in milimeters. The final image contrast is based on the maximum and minimum values over the entire image.");
BBTK_CATEGORY("Registration");

BBTK_INPUT(GridOnImageGenerator,In,"Input image",vtkImageData*,"");
BBTK_INPUT(GridOnImageGenerator,GridSpcX,"Grid spacing in X",double,"");
BBTK_INPUT(GridOnImageGenerator,GridSpcY,"Grid spacing in Y",double,"");
BBTK_INPUT(GridOnImageGenerator,GridSpcZ,"Grid spacing in Z",double,"");

BBTK_OUTPUT(GridOnImageGenerator,Out,"Output image",vtkImageData*,"");
BBTK_END_DESCRIBE_BLACK_BOX(GridOnImageGenerator);
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
}
// EO namespace bbPackRecalage

#endif // __bbPackRecalageGridOnImageGenerator_h_INCLUDED__

