/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------   
*/


#ifndef __bbPackRecalageImageSubstraction_h_INCLUDED__
#define __bbPackRecalageImageSubstraction_h_INCLUDED__
#include "bbPackRecalage_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"
#include "vtkImageData.h"

#include <string>
#include <vector>

#include "Substraction.h"


namespace bbPackRecalage
{
class bbPackRecalage_EXPORT ImageSubstraction
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(ImageSubstraction,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(In1,vtkImageData*);
  BBTK_DECLARE_INPUT(In2,vtkImageData*);
  BBTK_DECLARE_INPUT(In3,int);
  BBTK_DECLARE_INPUT(In4,int);
  BBTK_DECLARE_INPUT(InU,std::vector<double>);
  BBTK_DECLARE_INPUT(InM,std::vector<double>);
  BBTK_DECLARE_INPUT(InL,std::vector<double>);
  BBTK_DECLARE_OUTPUT(Out,vtkImageData*);
  BBTK_PROCESS(Process);
  void Process();

  private:
		Substraction* subImage;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(ImageSubstraction,bbtk::AtomicBlackBox);
BBTK_NAME("ImageSubstraction");
BBTK_AUTHOR("jn.trillos44@uniandes.edu.co");
BBTK_DESCRIPTION("Creates a image resulting from the substraction of the RGB values of 2 other images.");
BBTK_CATEGORY("__CATEGORY__");
BBTK_INPUT(ImageSubstraction,In1,"Image 1",vtkImageData*,"");
BBTK_INPUT(ImageSubstraction,In2,"Image 2",vtkImageData*,"");
BBTK_INPUT(ImageSubstraction,In3,"Upper Zero Level (Value between 0 and 255)",int,"");
BBTK_INPUT(ImageSubstraction,In4,"Lower Zero Level (Value between 0 and 255)",int,"");
BBTK_INPUT(ImageSubstraction,InU,"Upper Level Color (RGB)",std::vector<double>,"");
BBTK_INPUT(ImageSubstraction,InM,"Medium Level Color (RGB)",std::vector<double>,"");
BBTK_INPUT(ImageSubstraction,InL,"Lower Level Color (RGB)",std::vector<double>,"");
BBTK_OUTPUT(ImageSubstraction,Out,"Image Result",vtkImageData*,"");
BBTK_END_DESCRIBE_BLACK_BOX(ImageSubstraction);
}
// EO namespace bbCreaRecalage

#endif // __bbCreaRecalageImageSubstraction_h_INCLUDED__

