/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------   
*/


#ifndef __bbPackRecalageReSlicerBox_h_INCLUDED__
#define __bbPackRecalageReSlicerBox_h_INCLUDED__
#include "bbPackRecalage_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include "vtkImageReslice.h" 
#include "vtkTransform.h"
#include "vtkImageData.h"

#include "vtkIdentityTransform.h"
#include "vtkMatrix4x4.h"
#include <vtkImageChangeInformation.h>

namespace bbPackRecalage
{

class bbPackRecalage_EXPORT ReSlicerBox
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(ReSlicerBox,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(In,vtkImageData *);
  BBTK_DECLARE_INPUT(Origin,std::vector<int>);
  BBTK_DECLARE_INPUT(Transform,vtkTransform *);
  BBTK_DECLARE_INPUT(Centered,bool);
  BBTK_DECLARE_INPUT(Interpolate,bool);
  BBTK_DECLARE_OUTPUT(Out,vtkImageData *);
  BBTK_PROCESS(Process);
  void Process();

  vtkImageChangeInformation* image;
  vtkImageChangeInformation* imageResult;
  vtkImageReslice* slicer;

  int sizeBackInfo;
  double backInfoA[19];  //16+3

  void GetBackInfo(double *backInfo, vtkMatrix4x4 *vtkmatrix, std::vector<int> point );
  bool CompareBackInfo(double* , double *);
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(ReSlicerBox,bbtk::AtomicBlackBox);
BBTK_NAME("ReSlicerBox");
BBTK_AUTHOR("davila@creatis.insa-lyon.com");
BBTK_DESCRIPTION("Uses the vtk ReSlicer tool to modify an input image given a transformation filter.");
BBTK_CATEGORY("filter");
BBTK_INPUT(ReSlicerBox,In,"Image input",vtkImageData *,"");
BBTK_INPUT(ReSlicerBox,Origin,"Image Origin(x,y,z)",std::vector<int>,"");
BBTK_INPUT(ReSlicerBox,Transform,"Transform input",vtkTransform *,"");
BBTK_INPUT(ReSlicerBox,Centered,"Rotations of the image are in the center of the image. DEFAULT = False.",bool,"");
BBTK_INPUT(ReSlicerBox,Interpolate,"Linear interpolation On. DEFAULT = False.",bool,"");
BBTK_OUTPUT(ReSlicerBox,Out,"Image output",vtkImageData *,"");
BBTK_END_DESCRIBE_BLACK_BOX(ReSlicerBox);
}
// EO namespace bbPackRecalage

#endif // __bbPackRecalageReSlicerBox_h_INCLUDED__

