/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------   
*/


#ifndef __bbPackRecalageTransform3D1PointBox_h_INCLUDED__
#define __bbPackRecalageTransform3D1PointBox_INCLUDED__
#include "bbPackRecalage_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include "vtkTransform.h"
#include "Transformer3D1Point.h"

namespace bbPackRecalage
{

class bbPackRecalage_EXPORT Transform3D1PointBox
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(Transform3D1PointBox,bbtk::AtomicBlackBox);

  /*Center Point of the transformation*/
  BBTK_DECLARE_INPUT(CenterPoint,std::vector<int>);

  /*Scalation to be done in the x axis*/
  BBTK_DECLARE_INPUT(AngleX,double);
		
  /*Scalation to be done in the y axis*/
  BBTK_DECLARE_INPUT(AngleY,double);

  /*Scalation to be done in the z axis*/
  BBTK_DECLARE_INPUT(AngleZ,double);

  /*Scalation to be done in the x axis*/
  BBTK_DECLARE_INPUT(ScaleX,double);
		
  /*Scalation to be done in the y axis*/
  BBTK_DECLARE_INPUT(ScaleY,double);

  /*Scalation to be done in the z axis*/
  BBTK_DECLARE_INPUT(ScaleZ,double);

  /*Resultant vtkTransform*/
  BBTK_DECLARE_OUTPUT(Out, vtkTransform*);

  /*Class in charge of making the transformations*/
  Transformer3D1Point *transformer;

  BBTK_PROCESS(Process);
  void Process();
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(Transform3D1PointBox,bbtk::AtomicBlackBox);
BBTK_NAME("Transform3D1PointBox");
BBTK_AUTHOR("jn.trillos44@uniandes.edu.co");
BBTK_DESCRIPTION("Recalage3D version 1 (one point for translation, three rotation angles and xyz manual scaling)");
BBTK_CATEGORY("filter");
BBTK_INPUT(Transform3D1PointBox,CenterPoint,"CenterPoint",std::vector<int>,"");
BBTK_INPUT(Transform3D1PointBox,AngleX,"Angle for rotating on X",double,"");
BBTK_INPUT(Transform3D1PointBox,AngleY,"Angle for rotating on Y",double,"");
BBTK_INPUT(Transform3D1PointBox,AngleZ,"Angle for rotating on Z",double,"");
BBTK_INPUT(Transform3D1PointBox,ScaleX,"Scale on X",double,"");
BBTK_INPUT(Transform3D1PointBox,ScaleY,"Scale on Y",double,"");
BBTK_INPUT(Transform3D1PointBox,ScaleZ,"Scale on Z",double,"");
BBTK_OUTPUT(Transform3D1PointBox,Out,"Transformation ",vtkTransform*,"");
BBTK_END_DESCRIBE_BLACK_BOX(Transform3D1PointBox);
}
// EO namespace bbPackRecalage

#endif // __bbPackRecalageRecalage3DV1_h_INCLUDED__

