/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifdef _USE_WXWIDGETS_
#ifndef __bbCreaContournDimensions_h_INCLUDED__
#define __bbCreaContournDimensions_h_INCLUDED__
#include "bbtkWxBlackBox.h"

#include "wxContourMainFrame.h"

#include <map>
#include "vtkImageData.h"

#include "wx/artprov.h"
#include <wx/filedlg.h>

#include <vtkImageData.h>
#include <vtkMetaImageReader.h>

namespace bbcreaContours
{

class /*BBTK_EXPORT*/ nDimensions
 : 
   public bbtk::WxBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(nDimensions,bbtk::WxBlackBox);

//==================================================================
  BBTK_DECLARE_INPUT(WorkDir,std::string);
  BBTK_DECLARE_INPUT(In,vtkImageData*);
  BBTK_DECLARE_INPUT(ContourType,int);
  BBTK_PROCESS(Process);
  void Process();
  BBTK_CREATE_WIDGET(CreateWidget);
  void CreateWidget(wxWindow*);

  BBTK_DECLARE_OUTPUT(Mask,vtkImageData*);
  BBTK_DECLARE_OUTPUT(Value,vtkImageData*);
  BBTK_DECLARE_OUTPUT(X,double**);
  BBTK_DECLARE_OUTPUT(Y,double**);
  BBTK_DECLARE_OUTPUT(Z,double**);
  BBTK_DECLARE_OUTPUT(SizeContour,std::vector <int>);

private:
	//wxContourMainFrame* frame;
	vtkImageData* currentimg;
	//wxContourEventHandler * eventHandler;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(nDimensions, bbtk::WxBlackBox);
BBTK_NAME("nDimensions");
BBTK_AUTHOR("car-prie@uniandes.edu.co");
BBTK_DESCRIPTION("With a given image, the box shows the nDimension application");
BBTK_CATEGORY("contours");
BBTK_INPUT(nDimensions,WorkDir,"Working data directory where config and data files are located",std::string,"");
BBTK_INPUT(nDimensions,In,"Image to be shown",vtkImageData*,"");
BBTK_INPUT(nDimensions,ContourType,"Contour type to be exported: ",int,"");

BBTK_OUTPUT(nDimensions, Mask, "Mask of the contours",vtkImageData*,"");
BBTK_OUTPUT(nDimensions, Value, "Value of the contours",vtkImageData*,"");
BBTK_OUTPUT(nDimensions, X, "Array of arrays that contains the X coordinates of each contour", double**, "");
BBTK_OUTPUT(nDimensions, Y, "Array of arrays that contains the Y coordinates of each contour", double**, "");
BBTK_OUTPUT(nDimensions, Z, "Array of arrays that contains the Z coordinates of each contour", double**, "");
BBTK_OUTPUT(nDimensions, SizeContour, "Vector that contains the coordinates of each contour", std::vector <int>, "");

BBTK_END_DESCRIBE_BLACK_BOX(nDimensions);
}
// EO namespace bbCreaContour

#endif // __bbCreaContournDimensions_h_INCLUDED__
#endif // _USE_WXWIDGETS_
