/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifdef _USE_WXWIDGETS_
#ifndef __bbcreaMaracasVisuPlaneDirection_h_INCLUDED__
#define __bbcreaMaracasVisuPlaneDirection_h_INCLUDED__
#include "bbcreaMaracasVisu_EXPORT.h"
#include "bbtkWxBlackBox.h"

#include <vtkRenderer.h>
#include <vtkImageData.h>

#include "PlaneDirectionViewer.h"

namespace bbcreaMaracasVisu
{

class bbcreaMaracasVisu_EXPORT PlaneDirection
 : 
   public bbtk::WxBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(PlaneDirection,bbtk::WxBlackBox);

  BBTK_DECLARE_INPUT(In,vtkImageData*);  
  BBTK_DECLARE_INPUT(Renderer, vtkRenderer* );
  BBTK_DECLARE_INPUT(Filename, std::string );
  BBTK_DECLARE_INPUT( lstPointsX, std::vector<int> );
  BBTK_DECLARE_INPUT( lstPointsY, std::vector<int> );
  BBTK_DECLARE_INPUT( lstPointsZ, std::vector<int> );
  BBTK_DECLARE_INPUT( ArrowSize, int );
  BBTK_PROCESS(Process);
  void Process();
  BBTK_CREATE_WIDGET(CreateWidget);
  void CreateWidget(wxWindow*);

private:
	PlaneDirectionViewer* _planedir;
	int radio;
	double colour[3];
	int opacity;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(PlaneDirection,bbtk::WxBlackBox);
BBTK_NAME("PlaneDirection");
BBTK_AUTHOR("car-prie@uniandes.edu.co");
BBTK_DESCRIPTION("Given a list of points and grouping them in triplets, the box calculates the direction of the plane formed by the three points");
BBTK_CATEGORY("actor");

BBTK_INPUT(PlaneDirection,In,"Image data to get the spacing, if not found set to 1 1 1",vtkImageData*,"");
BBTK_INPUT(PlaneDirection,Renderer,"Renderer",vtkRenderer*,"");
BBTK_INPUT(PlaneDirection,Filename,"Filename to save the points of the plane and the direction",std::string,"");

BBTK_INPUT(PlaneDirection, lstPointsX, " list of points X ", std::vector<int>, "");
BBTK_INPUT(PlaneDirection, lstPointsY, " list of points Y ", std::vector<int>, "");
BBTK_INPUT(PlaneDirection, lstPointsZ, " list of points Z ", std::vector<int>, "");

BBTK_INPUT(PlaneDirection, ArrowSize, "Size of the arrow ", int, "");

BBTK_END_DESCRIBE_BLACK_BOX(PlaneDirection);
}
// EO namespace bbcreaMaracasVisu

#endif // __bbcreaMaracasVisuPlaneDirection_h_INCLUDED__
#endif // _USE_WXWIDGETS_

