/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

//=====
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//=====
#ifndef __bbcreaMaracasVisuTubeFilter_h_INCLUDED__
#define __bbcreaMaracasVisuTubeFilter_h_INCLUDED__
#include "bbcreaMaracasVisu_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include <vtkProp3D.h>
#include <vtkRenderer.h>
#include <vtkTransform.h>
#include <vtkActor.h>
#include <vtkLinearTransform.h>
#include <vtkSmartPointer.h>

namespace bbcreaMaracasVisu
{

	class MaracasTubeFilter
	{
	public:
		MaracasTubeFilter();
		~MaracasTubeFilter();

		void SetvtkRenderer( vtkRenderer *render);
		void SetlstPoints( std::vector<double> lstPointX , std::vector<double> lstPointY , std::vector<double> lstPointZ );
		void SetlstRadius( std::vector<double> lstRadius  );
		void SetlstColour( std::vector<double> lstColour  );
		void SetOpacity(double opacity);
		void SetTransform( vtkLinearTransform* transform  );
		vtkActor *GetActor();
		void Run();

		vtkRenderer *renderer;
		vtkSmartPointer<vtkActor> actor;

		double opacity;
		vtkLinearTransform *transform;
		std::vector<double> lstPointX;
		std::vector<double> lstPointY;
		std::vector<double> lstPointZ;
		std::vector<double> lstRadius;
		std::vector<double> lstColour;

	};

class bbcreaMaracasVisu_EXPORT TubeFilter
 :
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(TubeFilter,bbtk::AtomicBlackBox);
//=====
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//=====
	BBTK_DECLARE_INPUT(Renderer ,vtkRenderer*);
	BBTK_DECLARE_INPUT(lstPointX,std::vector<double>);
	BBTK_DECLARE_INPUT(lstPointY,std::vector<double>);
	BBTK_DECLARE_INPUT(lstPointZ,std::vector<double>);
	BBTK_DECLARE_INPUT(lstRadio ,std::vector<double>);
	BBTK_DECLARE_INPUT(Opacity,double);
	BBTK_DECLARE_INPUT(Colour   ,std::vector<double>);
	BBTK_DECLARE_INPUT(Transform, vtkLinearTransform *);

	BBTK_DECLARE_OUTPUT(OutAxis,vtkProp3D *);
  BBTK_PROCESS(Process);
  void Process();

	MaracasTubeFilter *tubefilter;

//=====
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//=====
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(TubeFilter,bbtk::AtomicBlackBox);
    BBTK_NAME("TubeFilter");
    BBTK_AUTHOR("Info-Dev");
    BBTK_DESCRIPTION("vtk Tube Filter");
	BBTK_CATEGORY("actor");
	BBTK_INPUT(TubeFilter,Renderer,"Renderer",vtkRenderer*,"");
	BBTK_INPUT(TubeFilter,lstPointX,"lstPointX",std::vector<double>,"");
	BBTK_INPUT(TubeFilter,lstPointY,"lstPointY",std::vector<double>,"");
	BBTK_INPUT(TubeFilter,lstPointZ,"lstPointZ",std::vector<double>,"");
	BBTK_INPUT(TubeFilter,lstRadio,"lstRadio. Default value is 1 everywhere.",std::vector<double>,"");
	BBTK_INPUT(TubeFilter,Colour,"Colour",std::vector<double>,"");
	BBTK_INPUT(TubeFilter,Transform,"vtkTransform", vtkLinearTransform *,"");
	BBTK_INPUT(TubeFilter,Opacity,"Opacity",double,"");
	BBTK_OUTPUT(TubeFilter,OutAxis,"Tube Actor",vtkProp3D *,"");
BBTK_END_DESCRIBE_BLACK_BOX(TubeFilter);
//=====
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//=====
}
// EO namespace bbcreaMaracasVisu

#endif // __bbcreaMaracasVisuTubeFilter_h_INCLUDED__

