/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __bbcreaMaracasVisuVolumeRendering_h_INCLUDED__
#define __bbcreaMaracasVisuVolumeRendering_h_INCLUDED__
#include "bbcreaMaracasVisu_EXPORT.h"
#include "bbtkWxBlackBox.h"
#include "iostream"


#include <vtkImageData.h>
#include <vtkRenderer.h>


namespace bbcreaMaracasVisu
{

class bbcreaMaracasVisu_EXPORT VolumeRendering
 : 
   public bbtk::WxBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(VolumeRendering,bbtk::WxBlackBox);
  
  BBTK_DECLARE_INPUT(In0,vtkImageData*);
  BBTK_DECLARE_INPUT(In1,vtkImageData*);
  BBTK_DECLARE_INPUT(In2,vtkImageData*);
  BBTK_DECLARE_INPUT(In3,vtkImageData*);
  BBTK_DECLARE_INPUT(Renderer,vtkRenderer*);

  BBTK_DECLARE_OUTPUT(Out0,vtkImageData*);
  BBTK_DECLARE_OUTPUT(Out1,vtkImageData*);
  BBTK_DECLARE_OUTPUT(Out2,vtkImageData*);
  BBTK_DECLARE_OUTPUT(Out3,vtkImageData*);
  
  
  /*BBTK_DECLARE_INPUT(GreyLevel, std::vector<double> );
	BBTK_DECLARE_INPUT(Value, std::vector<double> );
	BBTK_DECLARE_INPUT(GreyLevelColors, std::vector<double>);
	BBTK_DECLARE_INPUT(Red, std::vector<double>);
	BBTK_DECLARE_INPUT(Green, std::vector<double>);
	BBTK_DECLARE_INPUT(Blue, std::vector<double>);*/
	//BBTK_DECLARE_OUTPUT(Out,vtkProp3D*);	
  BBTK_PROCESS(Process);
  void Process();
  BBTK_CREATE_WIDGET(CreateWidget);
  void CreateWidget(wxWindow*);

private:
	vtkRenderer* _currentrenderer;

};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(VolumeRendering,bbtk::WxBlackBox);
BBTK_NAME("VolumeRendering");
BBTK_AUTHOR("car-prie@uniandes.edu.co");
BBTK_DESCRIPTION("Volume Rendering of a given image");
BBTK_CATEGORY("actor");

BBTK_INPUT(VolumeRendering,In0,"Image to create the volume rendering",vtkImageData*,"");
BBTK_INPUT(VolumeRendering,In1,"Image to create the volume rendering",vtkImageData*,"");
BBTK_INPUT(VolumeRendering,In2,"Image to create the volume rendering",vtkImageData*,"");
BBTK_INPUT(VolumeRendering,In3,"Image to create the volume rendering",vtkImageData*,"");
BBTK_INPUT(VolumeRendering,Renderer,"Renderer",vtkRenderer*,"");
BBTK_OUTPUT(VolumeRendering,Out0,"Output resulting image",vtkImageData*,"");
BBTK_OUTPUT(VolumeRendering,Out1,"Output resulting image",vtkImageData*,"");
BBTK_OUTPUT(VolumeRendering,Out2,"Output resulting image",vtkImageData*,"");
BBTK_OUTPUT(VolumeRendering,Out3,"Output resulting image",vtkImageData*,"");


//BBTK_OUTPUT(VolumeRendering,Out,"Prop3D resulting from the volume rendering",vtkProp3D*,"");

/*BBTK_INPUT(VolumeRendering,GreyLevel,"Greylevel related to the transparency",std::vector<double>,"");
  BBTK_INPUT(VolumeRendering,Value,"Value of the transparency in the transfer function",std::vector<double>,"");
  BBTK_INPUT(VolumeRendering,GreyLevelColors,"Grey level of the color in the transfer function",std::vector<double>,"");
  BBTK_INPUT(VolumeRendering,Red,"Red value according to the GreyLevelColors",std::vector<double>,"");
  BBTK_INPUT(VolumeRendering,Green,"Green value according to the GreyLevelColors",std::vector<double>,"");
  BBTK_INPUT(VolumeRendering,Blue,"Blue value according to the GreyLevelColors",std::vector<double>,"");*/
BBTK_END_DESCRIBE_BLACK_BOX(VolumeRendering);
}
// EO namespace bbcreaMaracasVisu

#endif // __bbcreaMaracasVisuVolumeRendering_h_INCLUDED__

