/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __bbmaracasvisuAnimationSphere_h_INCLUDED__
#define __bbmaracasvisuAnimationSphere_h_INCLUDED__
#include "bbtkAtomicBlackBox.h"
#include "iostream"


#include <vtkRenderer.h>
#include <vtkActor.h>
#include <vtkSphereSource.h>
#include <vtkLinearTransform.h>


namespace bbcreaMaracasVisu
{

class /*BBTK_EXPORT*/ AnimationSphere
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(AnimationSphere,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(Renderer ,vtkRenderer*);
  BBTK_DECLARE_INPUT(Index,int);
  BBTK_DECLARE_INPUT(Step,int);
  BBTK_DECLARE_INPUT(lstIndexs,std::vector<int>);
  BBTK_DECLARE_INPUT(lstPointX,std::vector<double>);
  BBTK_DECLARE_INPUT(lstPointY,std::vector<double>);
  BBTK_DECLARE_INPUT(lstPointZ,std::vector<double>);
  BBTK_DECLARE_INPUT(lstRadio ,std::vector<double>);
  BBTK_DECLARE_INPUT(Colour   ,std::vector<double>);
  BBTK_DECLARE_INPUT(Opacity  ,double);
  BBTK_DECLARE_INPUT(Transform, vtkLinearTransform *);
//  BBTK_DECLARE_OUTPUT(Out,double);
  BBTK_PROCESS(Process);
  void Process();

  vtkActor			*sphereActor;
  vtkSphereSource	*vtksphere;

};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(AnimationSphere,bbtk::AtomicBlackBox);
BBTK_NAME("AnimationSphere");
BBTK_AUTHOR("InfoTeam  CREATIS-LRMN");
BBTK_DESCRIPTION("Animation Sphere");
BBTK_CATEGORY("Animation");
BBTK_INPUT(AnimationSphere,Renderer,"Renderer",vtkRenderer*,"");
BBTK_INPUT(AnimationSphere,Index,"Indexs",int,"");
BBTK_INPUT(AnimationSphere,Step,"Step",int,"");
BBTK_INPUT(AnimationSphere,lstIndexs,"list of Indexs",std::vector<int>,"");
BBTK_INPUT(AnimationSphere,lstPointX,"lstPointX",std::vector<double>,"");
BBTK_INPUT(AnimationSphere,lstPointY,"lstPointY",std::vector<double>,"");
BBTK_INPUT(AnimationSphere,lstPointZ,"lstPointZ",std::vector<double>,"");
BBTK_INPUT(AnimationSphere,lstRadio,"lstRadio",std::vector<double>,"");
BBTK_INPUT(AnimationSphere,Colour,"Colour",std::vector<double>,"");
BBTK_INPUT(AnimationSphere,Opacity,"Opacity of the sphere",double,"");
BBTK_INPUT(AnimationSphere,Transform,"vtkTransform", vtkLinearTransform *,"");
//BBTK_OUTPUT(AnimationSphere,Out,"First output",double,"");
BBTK_END_DESCRIBE_BLACK_BOX(AnimationSphere);
}
// EO namespace bbcreaMaracasVisu

#endif // __bbmaracasvisuAnimationSphere_h_INCLUDED__

