/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifdef _USE_WXWIDGETS_
#ifndef __bbcreaMaracasVisuContourVOI_h_INCLUDED__
#define __bbcreaMaracasVisuContourVOI_h_INCLUDED__
#include "bbtkWxBlackBox.h"


#include <vtkImageData.h>

#include "Contour/ContourVOIWidget.h"

namespace bbcreaMaracasVisu
{


  //--------------------------------------------------------------------------
  class ContourVOI;
  class wxWidgetVOI : public wxPanel
  {
	public:
		wxWidgetVOI(wxWindow* parent, wxVtkBaseView *wxvtkbaseview=NULL, vtkImageData	*imagedata=NULL);
		~wxWidgetVOI();
	    
		//if the MPR had generated the refresh event
		void OnRefreshView(wxCommandEvent & event);
		void OnDClickLeft(wxCommandEvent & event); 

		//refreshView
		void Refresh();

		ContourVOIWidget* GetContourVOIWidget();

  	    void setImageData(vtkImageData * imagedata);
		void setBaseView(wxVtkBaseView * wxvtkbaseview);

		void initializeVOIWidget();

	private:

//		ContourVOI			*mbbViewerMPR;
		ContourVOIWidget	*mcontourvoiwidget;

		wxVtkBaseView * wxvtkbaseview;
		vtkImageData * imagedata;
		

		

	DECLARE_EVENT_TABLE( );	    
  };
  
  //------------------------------------------------------------------------
  //------------------------------------------------------------------------
  //------------------------------------------------------------------------






class /*BBTK_EXPORT*/ ContourVOI
 : 
   public bbtk::WxBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(ContourVOI,bbtk::WxBlackBox);
  BBTK_DECLARE_INPUT(Title,std::string);
    BBTK_DECLARE_INPUT(In, vtkImageData*);
    BBTK_DECLARE_INPUT(wxVtkBaseView, wxVtkBaseView*);
	BBTK_DECLARE_OUTPUT(Index,std::string);
	BBTK_DECLARE_OUTPUT(Size,std::string);
	BBTK_DECLARE_OUTPUT(VOI,vtkImageData*);
  BBTK_PROCESS(Process);
  void Process();
  BBTK_CREATE_WIDGET(CreateWidget);
  void CreateWidget(wxWindow*);

private:
	vtkImageData* _img;
	wxVtkBaseView* _base;
//EED 20Juin2011	vtkExtractVOI*	_extract;

};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(ContourVOI,bbtk::WxBlackBox);
BBTK_NAME("ContourVOI");
BBTK_AUTHOR("Eduardo.Davila [at] creatis.insa-lyon.fr");
BBTK_DESCRIPTION("define VOI widget");
//BBTK_CATEGORY("__CategoryBlackBox__");
    BBTK_INPUT(ContourVOI,Title,"Title prepended to the text",std::string,"");
	BBTK_INPUT(ContourVOI,In,"Input Image", vtkImageData *,"" );
	BBTK_INPUT(ContourVOI,wxVtkBaseView,"maracas visu wxVtkBaseView",wxVtkBaseView*,"");
	BBTK_OUTPUT(ContourVOI,Index, "Index"	,	std::string,"");
	BBTK_OUTPUT(ContourVOI,Size, "Size"	,	std::string,"");
	BBTK_OUTPUT(ContourVOI,VOI,"Region of interest",vtkImageData*,"");
BBTK_END_DESCRIBE_BLACK_BOX(ContourVOI);
}
// EO namespace bbcreaMaracasVisu

#endif // __bbcreaMaracasVisuContourVOI_h_INCLUDED__
#endif // _USE_WXWIDGETS_

