/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifdef _USE_WXWIDGETS_
#ifndef __bbcreaMaracasVisuPlotterView_h_INCLUDED__
#define __bbcreaMaracasVisuPlotterView_h_INCLUDED__
#include "bbtkWxBlackBox.h"

#include "pPlotterWindow.h"

namespace bbcreaMaracasVisu
{

class /*BBTK_EXPORT*/ PlotterView
 : 
   public bbtk::WxBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(PlotterView,bbtk::WxBlackBox);
	BBTK_DECLARE_INPUT(InX, std::vector<double> );
	BBTK_DECLARE_INPUT(InY, std::vector<double> );
	BBTK_DECLARE_INPUT(InY2, std::vector<double> );
  BBTK_PROCESS(Process);
  void Process();
  BBTK_CREATE_WIDGET(CreateWidget);
  void CreateWidget(wxWindow*);

private:
	pPlotterWindow *mwxwidget;
	bool firsttime;

};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(PlotterView,bbtk::WxBlackBox);
BBTK_NAME("PlotterView");
BBTK_AUTHOR("eduardo.davila [at] creatis.insa-lyon.fr");
BBTK_DESCRIPTION("Plotter Window");
BBTK_CATEGORY("viewer");
  BBTK_INPUT(PlotterView,InX,"x vector",std::vector<double>,"");
  BBTK_INPUT(PlotterView,InY,"y vector",std::vector<double>,"");
	BBTK_INPUT(PlotterView,InY2,"y2 vector",std::vector<double>,"");
BBTK_END_DESCRIBE_BLACK_BOX(PlotterView);
}
// EO namespace bbcreaMaracasVisu

#endif // __bbcreaMaracasVisuPlotterView_h_INCLUDED__
#endif // _USE_WXWIDGETS_

