/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifdef _USE_WXWIDGETS_
#ifndef __bbcreaMaracasVisuSliderMinMax_h_INCLUDED__
#define __bbcreaMaracasVisuSliderMinMax_h_INCLUDED__
#include "bbtkWxBlackBox.h"

#include "mBarRange.h"

namespace bbcreaMaracasVisu
{


//--------------------------------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------------------------------

  class SliderMinMax;
  //------------------------------------------------------------------------------------------------------------------------------------
  // Event handling auxiliar class
  //------------------------------------------------------------------------------------------------------------------------------------
  class wxWidgetSliderMinMax : wxEvtHandler
  {
  public:
	  //--------------------------------------------------------------------------------------------------------------------------------
	  // Constructors ans destructors
	  //--------------------------------------------------------------------------------------------------------------------------------
		wxWidgetSliderMinMax(SliderMinMax *bbParent,mBarRange * modelBarRange);
		~wxWidgetSliderMinMax();		

	  //--------------------------------------------------------------------------------------------------------------------------------
	  // Min-Max Barrange received events
	  //--------------------------------------------------------------------------------------------------------------------------------
		void onBarrange(wxCommandEvent& event);
		void onActualChange_Bar(wxCommandEvent& event);
		void onStartChange_Bar(wxCommandEvent& event);
		void onEndChange_Bar(wxCommandEvent& event);
		void onSelectionEnd(wxCommandEvent& event);
		void onMovedBar(wxCommandEvent& event);
	   void PushEventHandler();


  private:
	  //--------------------------------------------------------------------------------------------------------------------------------
	  // Attributes
	  //--------------------------------------------------------------------------------------------------------------------------------
	  SliderMinMax	*mbbtkSliderMinMax;
	  mBarRange		*modBarRange;
  };



//--------------------------------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------------------------------



class /*BBTK_EXPORT*/ SliderMinMax
 : 
   public bbtk::WxBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(SliderMinMax,bbtk::WxBlackBox);
	BBTK_DECLARE_INPUT(Orientation, int);
	BBTK_DECLARE_INPUT(InW, int);
	BBTK_DECLARE_INPUT(InH, int);
	BBTK_DECLARE_INPUT(InMax, int );
	BBTK_DECLARE_INPUT(InMin, int );
	BBTK_DECLARE_INPUT(InMaxShow, int );
	BBTK_DECLARE_INPUT(InMinShow, int );
	BBTK_DECLARE_INPUT(ShowLabels, int );
	BBTK_DECLARE_INPUT(ShowActual, bool );
    BBTK_DECLARE_OUTPUT(OutStart,int);
	BBTK_DECLARE_OUTPUT(OutEnd,int);
	BBTK_DECLARE_OUTPUT(OutActual,int);
  BBTK_PROCESS(Process);
  void Process();
  BBTK_CREATE_WIDGET(CreateWidget);
  void CreateWidget(wxWindow*);

  private:
	bool			firsttime;
	mBarRange		*mwxwidget;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(SliderMinMax,bbtk::WxBlackBox);
BBTK_NAME("SliderMinMax");
BBTK_AUTHOR("eduardo.davila [at] creatis.insa-lyon.fr");
BBTK_DESCRIPTION("Slider min max");
//BBTK_CATEGORY("__CategoryBlackBox__");
  BBTK_INPUT(SliderMinMax,Orientation,"Orientation ", int,"");
  BBTK_INPUT(SliderMinMax,InW,"Width ", int,"");
  BBTK_INPUT(SliderMinMax,InH,"Height ", int,"");
  BBTK_INPUT(SliderMinMax,InMax,"Max value ", int,"");
  BBTK_INPUT(SliderMinMax,InMin, "Min value ",int ,"");
  BBTK_INPUT(SliderMinMax,InMaxShow,"Max showed value ", int ,"");
  BBTK_INPUT(SliderMinMax,InMinShow, "Min showed value ",int ,"");
  BBTK_INPUT(SliderMinMax,ShowLabels, "Show labels ",int ,"");
  BBTK_INPUT(SliderMinMax,ShowActual, "Show actual (default true)",bool ,"");
  BBTK_OUTPUT(SliderMinMax,OutStart,"Min value output",int,"");
  BBTK_OUTPUT(SliderMinMax,OutEnd,"Max value output",int,"");
  BBTK_OUTPUT(SliderMinMax,OutActual,"Actual value output",int,"");
BBTK_END_DESCRIBE_BLACK_BOX(SliderMinMax);
}
// EO namespace bbcreaMaracasVisu

#endif // __bbcreaMaracasVisuSliderMinMax_h_INCLUDED__
#endif // _USE_WXWIDGETS_

