/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbitkImage.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:50:39 $
  Version:   $Revision: 1.9 $
=========================================================================*/




#ifdef _USE_ITK_

#ifndef __BBITKIMAGE_H_INCLUDED__
#define __BBITKIMAGE_H_INCLUDED__

#include "itkImage.h"
#include "bbtkAny.h"
#include "bbtkSystem.h"

namespace bbitk
{

  // bbtk typedefs for itk images
#define BBTK_TYPEDEF_ITK_IMAGE(TYPE,DIM)				\
  typedef itk::Image<TYPE,DIM> Image_##TYPE##_##DIM;			\
    typedef const Image_##TYPE##_##DIM Image_##TYPE##_##DIM##_c;	\
  typedef Image_##TYPE##_##DIM * Image_##TYPE##_##DIM##_ptr;		\
  typedef Image_##TYPE##_##DIM##_c * Image_##TYPE##_##DIM##_cptr;


#define BBTK_TYPEDEF_ITK_IMAGES_DIM(DIM)	\
  BBTK_TYPEDEF_ITK_IMAGE(int8_t,DIM);		\
    BBTK_TYPEDEF_ITK_IMAGE(uint8_t,DIM);	\
    BBTK_TYPEDEF_ITK_IMAGE(int16_t,DIM);	\
    BBTK_TYPEDEF_ITK_IMAGE(uint16_t,DIM);	\
    BBTK_TYPEDEF_ITK_IMAGE(int32_t,DIM);	\
    BBTK_TYPEDEF_ITK_IMAGE(uint32_t,DIM);	\
    BBTK_TYPEDEF_ITK_IMAGE(float,DIM);		\
    BBTK_TYPEDEF_ITK_IMAGE(double,DIM)
  
  BBTK_TYPEDEF_ITK_IMAGES_DIM(2);
  BBTK_TYPEDEF_ITK_IMAGES_DIM(3);
  BBTK_TYPEDEF_ITK_IMAGES_DIM(4);
  //BBTK_TYPEDEF_ITK_IMAGES_DIM(5)



#define BBTK_BEGIN_TEMPLATE_SWITCH(TYPE_INFO) if (false) {}

#define BBTK_END_TEMPLATE_SWITCH(TYPE_INFO) else { bbtkError("bbtk was not built for itk images of type <"<< bbtk::demangle_type_name(TYPE_INFO.name())<<">"); }

#define BBTK_END_TEMPLATE_SWITCH_MESSAGE(TYPE_INFO,MESSAGE) else { bbtkError(MESSAGE); }

  /// Generic macro which calls a TEMPLATE_FUNCTION instanciated 
  /// on TEMPLATE_TYPE iff TYPE_INFO == typeid(TEST_TYPE).
  /// This macro must be used (maybe several times) between a pair of BEGIN_TEMPLATE_SWITCH and END_TEMPLATE_SWITCH macros
#define TEMPLATE_SWITCH(TYPE_INFO,TEST_TYPE,TEMPLATE_FUNCTION,TEMPLATE_TYPE)    \
  else if (TYPE_INFO == typeid(bbitk::TEST_TYPE))                               \
    { TEMPLATE_FUNCTION<bbitk::TEMPLATE_TYPE>(); }


// DIMENSION 2
#ifdef BBTK_ITK_IMAGE_DIM_2
#  ifdef BBTK_ITK_IMAGE_TYPE_int8_t 
#    define BBTK_SWITCH_ITK_IMAGE_int8_t_2(TYPE_INFO,FUN,CONST)	                \
  TEMPLATE_SWITCH(TYPE_INFO,Image_int8_t_2_##CONST##ptr,FUN,Image_int8_t_2)
#  else
#    define BBTK_SWITCH_ITK_IMAGE_int8_t_2(TYPE_INFO,FUN,CONST)
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_int16_t
#    define BBTK_SWITCH_ITK_IMAGE_int16_t_2(TYPE_INFO,FUN,CONST)                \
  TEMPLATE_SWITCH(TYPE_INFO,Image_int16_t_2_##CONST##ptr,FUN,Image_int16_t_2)
#  else
#    define BBTK_SWITCH_ITK_IMAGE_int16_t_2(TYPE_INFO,FUN,CONST)
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_int32_t
#    define BBTK_SWITCH_ITK_IMAGE_int32_t_2(TYPE_INFO,FUN,CONST)		\
  TEMPLATE_SWITCH(TYPE_INFO,Image_int32_t_2_##CONST##ptr,FUN,Image_int32_t_2)
#  else
#    define BBTK_SWITCH_ITK_IMAGE_int32_t_2(TYPE_INFO,FUN,CONST)
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint8_t 
#    define BBTK_SWITCH_ITK_IMAGE_uint8_t_2(TYPE_INFO,FUN,CONST)		\
  TEMPLATE_SWITCH(TYPE_INFO,Image_uint8_t_2_##CONST##ptr,FUN,Image_uint8_t_2)
#  else
#    define BBTK_SWITCH_ITK_IMAGE_uint8_t_2(TYPE_INFO,FUN,CONST)
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_int16_t
#    define BBTK_SWITCH_ITK_IMAGE_uint16_t_2(TYPE_INFO,FUN,CONST)               \
  TEMPLATE_SWITCH(TYPE_INFO,Image_uint16_t_2_##CONST##ptr,FUN,Image_uint16_t_2)
#  else
#    define BBTK_SWITCH_ITK_IMAGE_uint16_t_2(TYPE_INFO,FUN,CONST)
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint32_t
#    define BBTK_SWITCH_ITK_IMAGE_uint32_t_2(TYPE_INFO,FUN,CONST)		\
  TEMPLATE_SWITCH(TYPE_INFO,Image_uint32_t_2_##CONST##ptr,FUN,Image_uint32_t_2)
#  else
#    define BBTK_SWITCH_ITK_IMAGE_uint32_t_2(TYPE_INFO,FUN,CONST)
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_float
#    define BBTK_SWITCH_ITK_IMAGE_float_2(TYPE_INFO,FUN,CONST)                  \
  TEMPLATE_SWITCH(TYPE_INFO,Image_float_2_##CONST##ptr,FUN,Image_float_2)
#  else
#    define BBTK_SWITCH_ITK_IMAGE_float_2(TYPE_INFO,FUN,CONST)
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_double
#    define BBTK_SWITCH_ITK_IMAGE_double_2(TYPE_INFO,FUN,CONST)                 \
  TEMPLATE_SWITCH(TYPE_INFO,Image_double_2_##CONST##ptr,FUN,Image_double_2)
#  else
#    define BBTK_SWITCH_ITK_IMAGE_double_2(TYPE_INFO,FUN,CONST)
#  endif
#else
#  define BBTK_SWITCH_ITK_IMAGE_int8_t_2(TYPE_INFO,FUN,CONST) 
#  define BBTK_SWITCH_ITK_IMAGE_int16_t_2(TYPE_INFO,FUN,CONST)
#  define BBTK_SWITCH_ITK_IMAGE_int32_t_2(TYPE_INFO,FUN,CONST)
#  define BBTK_SWITCH_ITK_IMAGE_uint8_t_2(TYPE_INFO,FUN,CONST)
#  define BBTK_SWITCH_ITK_IMAGE_uint16_t_2(TYPE_INFO,FUN,CONST)
#  define BBTK_SWITCH_ITK_IMAGE_uint32_t_2(TYPE_INFO,FUN,CONST)
#  define BBTK_SWITCH_ITK_IMAGE_float_2(TYPE_INFO,FUN,CONST)
#  define BBTK_SWITCH_ITK_IMAGE_double_2(TYPE_INFO,FUN,CONST)
#endif


// DIMENSION 3
#ifdef BBTK_ITK_IMAGE_DIM_3
#  ifdef BBTK_ITK_IMAGE_TYPE_int8_t 
#    define BBTK_SWITCH_ITK_IMAGE_int8_t_3(TYPE_INFO,FUN,CONST)                 \
  TEMPLATE_SWITCH(TYPE_INFO,Image_int8_t_3_##CONST##ptr,FUN,Image_int8_t_3)
#  else
#    define BBTK_SWITCH_ITK_IMAGE_int8_t_3(TYPE_INFO,FUN,CONST)
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_int16_t
#    define BBTK_SWITCH_ITK_IMAGE_int16_t_3(TYPE_INFO,FUN,CONST)		\
  TEMPLATE_SWITCH(TYPE_INFO,Image_int16_t_3_##CONST##ptr,FUN,Image_int16_t_3)
#  else
#    define BBTK_SWITCH_ITK_IMAGE_int16_t_3(TYPE_INFO,FUN,CONST)
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_int32_t
#    define BBTK_SWITCH_ITK_IMAGE_int32_t_3(TYPE_INFO,FUN,CONST)		\
  TEMPLATE_SWITCH(TYPE_INFO,Image_int32_t_3_##CONST##ptr,FUN,Image_int32_t_3)
#  else
#    define BBTK_SWITCH_ITK_IMAGE_int32_t_3(TYPE_INFO,FUN,CONST)
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint8_t 
#    define BBTK_SWITCH_ITK_IMAGE_uint8_t_3(TYPE_INFO,FUN,CONST)		\
  TEMPLATE_SWITCH(TYPE_INFO,Image_uint8_t_3_##CONST##ptr,FUN,Image_uint8_t_3)
#  else
#    define BBTK_SWITCH_ITK_IMAGE_uint8_t_3(TYPE_INFO,FUN,CONST)
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_int16_t
#    define BBTK_SWITCH_ITK_IMAGE_uint16_t_3(TYPE_INFO,FUN,CONST)		\
  TEMPLATE_SWITCH(TYPE_INFO,Image_uint16_t_3_##CONST##ptr,FUN,Image_uint16_t_3)
#  else
#    define BBTK_SWITCH_ITK_IMAGE_uint16_t_3(TYPE_INFO,FUN,CONST)
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint32_t
#    define BBTK_SWITCH_ITK_IMAGE_uint32_t_3(TYPE_INFO,FUN,CONST)		\
  TEMPLATE_SWITCH(TYPE_INFO,Image_uint32_t_3_##CONST##ptr,FUN,Image_uint32_t_3)
#  else
#    define BBTK_SWITCH_ITK_IMAGE_uint32_t_3(TYPE_INFO,FUN,CONST)
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_float
#    define BBTK_SWITCH_ITK_IMAGE_float_3(TYPE_INFO,FUN,CONST)                  \
  TEMPLATE_SWITCH(TYPE_INFO,Image_float_3_##CONST##ptr,FUN,Image_float_3)
#  else
#    define BBTK_SWITCH_ITK_IMAGE_float_3(TYPE_INFO,FUN,CONST)
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_double
#    define BBTK_SWITCH_ITK_IMAGE_double_3(TYPE_INFO,FUN,CONST)                 \
  TEMPLATE_SWITCH(TYPE_INFO,Image_double_3_##CONST##ptr,FUN,Image_double_3)
#  else
#    define BBTK_SWITCH_ITK_IMAGE_double_3(TYPE_INFO,FUN,CONST)
#  endif
#else
#  define BBTK_SWITCH_ITK_IMAGE_int8_t_3(TYPE_INFO,FUN,CONST)
#  define BBTK_SWITCH_ITK_IMAGE_int16_t_3(TYPE_INFO,FUN,CONST)
#  define BBTK_SWITCH_ITK_IMAGE_int32_t_3(TYPE_INFO,FUN,CONST)
#  define BBTK_SWITCH_ITK_IMAGE_uint8_t_3(TYPE_INFO,FUN,CONST)
#  define BBTK_SWITCH_ITK_IMAGE_uint16_t_3(TYPE_INFO,FUN,CONST)
#  define BBTK_SWITCH_ITK_IMAGE_uint32_t_3(TYPE_INFO,FUN,CONST)
#  define BBTK_SWITCH_ITK_IMAGE_float_3(TYPE_INFO,FUN,CONST)
#  define BBTK_SWITCH_ITK_IMAGE_double_3(TYPE_INFO,FUN,CONST)
#endif


  // DIMENSION 4
#ifdef BBTK_ITK_IMAGE_DIM_4
#  ifdef BBTK_ITK_IMAGE_TYPE_int8_t 
#    define BBTK_SWITCH_ITK_IMAGE_int8_t_4(TYPE_INFO,FUN,CONST)                 \
  TEMPLATE_SWITCH(TYPE_INFO,Image_int8_t_4_##CONST##ptr,FUN,Image_int8_t_4)
#  else
#    define BBTK_SWITCH_ITK_IMAGE_int8_t_4(TYPE_INFO,FUN,CONST)
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_int16_t
#    define BBTK_SWITCH_ITK_IMAGE_int16_t_4(TYPE_INFO,FUN,CONST)		\
  TEMPLATE_SWITCH(TYPE_INFO,Image_int16_t_4_##CONST##ptr,FUN,Image_int16_t_4)
#  else
#    define BBTK_SWITCH_ITK_IMAGE_int16_t_4(TYPE_INFO,FUN,CONST)
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_int32_t
#    define BBTK_SWITCH_ITK_IMAGE_int32_t_4(TYPE_INFO,FUN,CONST)		\
  TEMPLATE_SWITCH(TYPE_INFO,Image_int32_t_4_##CONST##ptr,FUN,Image_int32_t_4)
#  else
#    define BBTK_SWITCH_ITK_IMAGE_int32_t_4(TYPE_INFO,FUN,CONST)
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint8_t 
#    define BBTK_SWITCH_ITK_IMAGE_uint8_t_4(TYPE_INFO,FUN,CONST)		\
  TEMPLATE_SWITCH(TYPE_INFO,Image_uint8_t_4_##CONST##ptr,FUN,Image_uint8_t_4)
#  else
#    define BBTK_SWITCH_ITK_IMAGE_uint8_t_4(TYPE_INFO,FUN,CONST)
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_int16_t
#    define BBTK_SWITCH_ITK_IMAGE_uint16_t_4(TYPE_INFO,FUN,CONST)		\
  TEMPLATE_SWITCH(TYPE_INFO,Image_uint16_t_4_##CONST##ptr,FUN,Image_uint16_t_4)
#  else
#    define BBTK_SWITCH_ITK_IMAGE_uint16_t_4(TYPE_INFO,FUN,CONST)
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint32_t
#    define BBTK_SWITCH_ITK_IMAGE_uint32_t_4(TYPE_INFO,FUN,CONST)               \
  TEMPLATE_SWITCH(TYPE_INFO,Image_uint32_t_4_##CONST##ptr,FUN,Image_uint32_t_4)
#  else
#    define BBTK_SWITCH_ITK_IMAGE_uint32_t_4(TYPE_INFO,FUN,CONST)
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_float
#    define BBTK_SWITCH_ITK_IMAGE_float_4(TYPE_INFO,FUN,CONST)                  \
  TEMPLATE_SWITCH(TYPE_INFO,Image_float_4_##CONST##ptr,FUN,Image_float_4)
#  else
#    define BBTK_SWITCH_ITK_IMAGE_float_4(TYPE_INFO,FUN,CONST)
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_double
#    define BBTK_SWITCH_ITK_IMAGE_double_4(TYPE_INFO,FUN,CONST)                 \
  TEMPLATE_SWITCH(TYPE_INFO,Image_double_4_##CONST##ptr,FUN,Image_double_4)
#  else
#    define BBTK_SWITCH_ITK_IMAGE_double_4(TYPE_INFO,FUN,CONST)
#  endif
#else
#  define BBTK_SWITCH_ITK_IMAGE_int8_t_4(TYPE_INFO,FUN,CONST) 
#  define BBTK_SWITCH_ITK_IMAGE_int16_t_4(TYPE_INFO,FUN,CONST)
#  define BBTK_SWITCH_ITK_IMAGE_int32_t_4(TYPE_INFO,FUN,CONST)
#  define BBTK_SWITCH_ITK_IMAGE_uint8_t_4(TYPE_INFO,FUN,CONST)
#  define BBTK_SWITCH_ITK_IMAGE_uint16_t_4(TYPE_INFO,FUN,CONST)
#  define BBTK_SWITCH_ITK_IMAGE_uint32_t_4(TYPE_INFO,FUN,CONST)
#  define BBTK_SWITCH_ITK_IMAGE_float_4(TYPE_INFO,FUN,CONST)
#  define BBTK_SWITCH_ITK_IMAGE_double_4(TYPE_INFO,FUN,CONST)
#endif


  /// General macro which calls the template function FUN instanciated 
  /// on the right type of itk image depending on the value of TYPE_INFO (which must be of type type_info). 
#define BBTK_TEMPLATE_ITK_IMAGE_SWITCH(TYPE_INFO,FUN)	\
  BBTK_BEGIN_TEMPLATE_SWITCH(TYPE_INFO)			\
    BBTK_SWITCH_ITK_IMAGE_int8_t_2(TYPE_INFO,FUN,)	\
    BBTK_SWITCH_ITK_IMAGE_int16_t_2(TYPE_INFO,FUN,)	\
    BBTK_SWITCH_ITK_IMAGE_int32_t_2(TYPE_INFO,FUN,)	\
    BBTK_SWITCH_ITK_IMAGE_uint8_t_2(TYPE_INFO,FUN,)	\
    BBTK_SWITCH_ITK_IMAGE_uint16_t_2(TYPE_INFO,FUN,)	\
    BBTK_SWITCH_ITK_IMAGE_uint32_t_2(TYPE_INFO,FUN,)	\
    BBTK_SWITCH_ITK_IMAGE_float_2(TYPE_INFO,FUN,)	\
    BBTK_SWITCH_ITK_IMAGE_double_2(TYPE_INFO,FUN,)	\
    BBTK_SWITCH_ITK_IMAGE_int8_t_3(TYPE_INFO,FUN,)	\
    BBTK_SWITCH_ITK_IMAGE_int16_t_3(TYPE_INFO,FUN,)	\
    BBTK_SWITCH_ITK_IMAGE_int32_t_3(TYPE_INFO,FUN,)	\
    BBTK_SWITCH_ITK_IMAGE_uint8_t_3(TYPE_INFO,FUN,)	\
    BBTK_SWITCH_ITK_IMAGE_uint16_t_3(TYPE_INFO,FUN,)	\
    BBTK_SWITCH_ITK_IMAGE_uint32_t_3(TYPE_INFO,FUN,)	\
    BBTK_SWITCH_ITK_IMAGE_float_3(TYPE_INFO,FUN,)	\
    BBTK_SWITCH_ITK_IMAGE_double_3(TYPE_INFO,FUN,)	\
    BBTK_SWITCH_ITK_IMAGE_int8_t_4(TYPE_INFO,FUN,)	\
    BBTK_SWITCH_ITK_IMAGE_int16_t_4(TYPE_INFO,FUN,)	\
    BBTK_SWITCH_ITK_IMAGE_int32_t_4(TYPE_INFO,FUN,)	\
    BBTK_SWITCH_ITK_IMAGE_uint8_t_4(TYPE_INFO,FUN,)	\
    BBTK_SWITCH_ITK_IMAGE_uint16_t_4(TYPE_INFO,FUN,)	\
    BBTK_SWITCH_ITK_IMAGE_uint32_t_4(TYPE_INFO,FUN,)	\
    BBTK_SWITCH_ITK_IMAGE_float_4(TYPE_INFO,FUN,)	\
    BBTK_SWITCH_ITK_IMAGE_double_4(TYPE_INFO,FUN,)	\
  BBTK_END_TEMPLATE_SWITCH(TYPE_INFO)



  /// General macro which calls the template function FUN instanciated 
  /// on the right type of itk image depending on the value of TYPE_INFO (which must be of type type_info). 
#define BBTK_TEMPLATE_ITK_IMAGE_DIM_3_SWITCH(TYPE_INFO,FUN,ERROR_MESSAGE) \
  BBTK_BEGIN_TEMPLATE_SWITCH(TYPE_INFO)			\
    BBTK_SWITCH_ITK_IMAGE_int8_t_3(TYPE_INFO,FUN,)	\
    BBTK_SWITCH_ITK_IMAGE_int16_t_3(TYPE_INFO,FUN,)	\
    BBTK_SWITCH_ITK_IMAGE_int32_t_3(TYPE_INFO,FUN,)	\
    BBTK_SWITCH_ITK_IMAGE_uint8_t_3(TYPE_INFO,FUN,)	\
    BBTK_SWITCH_ITK_IMAGE_uint16_t_3(TYPE_INFO,FUN,)	\
    BBTK_SWITCH_ITK_IMAGE_uint32_t_3(TYPE_INFO,FUN,)	\
    BBTK_SWITCH_ITK_IMAGE_float_3(TYPE_INFO,FUN,)	\
    BBTK_SWITCH_ITK_IMAGE_double_3(TYPE_INFO,FUN,)	\
  BBTK_END_TEMPLATE_SWITCH_MESSAGE(TYPE_INFO,ERROR_MESSAGE)


  /// General macro which calls the template function FUN instanciated 
  /// on the right type of itk image depending on the value of TYPE_INFO (which must be of type type_info). 

#define BBTK_TEMPLATE_CONST_ITK_IMAGE_SWITCH(TYPE_INFO,FUN) \
  BBTK_BEGIN_TEMPLATE_SWITCH(TYPE_INFO)			\
    BBTK_SWITCH_ITK_IMAGE_int8_t_2(TYPE_INFO,FUN,c)	\
    BBTK_SWITCH_ITK_IMAGE_int16_t_2(TYPE_INFO,FUN,c)	\
    BBTK_SWITCH_ITK_IMAGE_int32_t_2(TYPE_INFO,FUN,c)	\
    BBTK_SWITCH_ITK_IMAGE_uint8_t_2(TYPE_INFO,FUN,c)	\
    BBTK_SWITCH_ITK_IMAGE_uint16_t_2(TYPE_INFO,FUN,c)	\
    BBTK_SWITCH_ITK_IMAGE_uint32_t_2(TYPE_INFO,FUN,c)	\
    BBTK_SWITCH_ITK_IMAGE_float_2(TYPE_INFO,FUN,c)	\
    BBTK_SWITCH_ITK_IMAGE_double_2(TYPE_INFO,FUN,c)	\
    BBTK_SWITCH_ITK_IMAGE_int8_t_3(TYPE_INFO,FUN,c)	\
    BBTK_SWITCH_ITK_IMAGE_int16_t_3(TYPE_INFO,FUN,c)	\
    BBTK_SWITCH_ITK_IMAGE_int32_t_3(TYPE_INFO,FUN,c)	\
    BBTK_SWITCH_ITK_IMAGE_uint8_t_3(TYPE_INFO,FUN,c)	\
    BBTK_SWITCH_ITK_IMAGE_uint16_t_3(TYPE_INFO,FUN,c)	\
    BBTK_SWITCH_ITK_IMAGE_uint32_t_3(TYPE_INFO,FUN,c)	\
    BBTK_SWITCH_ITK_IMAGE_float_3(TYPE_INFO,FUN,c)	\
    BBTK_SWITCH_ITK_IMAGE_double_3(TYPE_INFO,FUN,c)	\
    BBTK_SWITCH_ITK_IMAGE_int8_t_4(TYPE_INFO,FUN,c)	\
    BBTK_SWITCH_ITK_IMAGE_int16_t_4(TYPE_INFO,FUN,c)	\
    BBTK_SWITCH_ITK_IMAGE_int32_t_4(TYPE_INFO,FUN,c)	\
    BBTK_SWITCH_ITK_IMAGE_uint8_t_4(TYPE_INFO,FUN,c)	\
    BBTK_SWITCH_ITK_IMAGE_uint16_t_4(TYPE_INFO,FUN,c)	\
    BBTK_SWITCH_ITK_IMAGE_uint32_t_4(TYPE_INFO,FUN,c)	\
    BBTK_SWITCH_ITK_IMAGE_float_4(TYPE_INFO,FUN,c)	\
    BBTK_SWITCH_ITK_IMAGE_double_4(TYPE_INFO,FUN,c)	\
  BBTK_END_TEMPLATE_SWITCH(TYPE_INFO)      

#define BBTK_GITIFPTI_DIM(DIM)				\
  if (pti == typeid(unsigned char))			\
    return typeid(itk::Image<unsigned char,DIM>*);	\
    if (pti == typeid(unsigned short))			\
      return typeid(itk::Image<unsigned short,DIM>*);	\
    if (pti == typeid(unsigned int))			\
      return typeid(itk::Image<unsigned int,DIM>*);	\
    if (pti == typeid(unsigned long))			\
      return typeid(itk::Image<unsigned long,DIM>*);	\
    if (pti == typeid(signed char))			\
      return typeid(itk::Image<signed char,DIM>*);	\
    if (pti == typeid(signed short))			\
      return typeid(itk::Image<signed short,DIM>*);	\
    if (pti == typeid(signed int))			\
      return typeid(itk::Image<signed int,DIM>*);	\
    if (pti == typeid(signed long))			\
      return typeid(itk::Image<signed long,DIM>*);	\
    if (pti == typeid(float))				\
      return typeid(itk::Image<float,DIM>*);		\
    if (pti == typeid(double))				\
      return typeid(itk::Image<double,DIM>*);


  inline bbtk::TypeInfo GetITKImagePtrTypeInfoFromPixelTypeInfoAndDimension( 
									    bbtk::TypeInfo pti,
									    unsigned int dim )
  {
    if      (dim==2) { BBTK_GITIFPTI_DIM(2); }
    else if (dim==3) { BBTK_GITIFPTI_DIM(3); }
    else if (dim==4) { BBTK_GITIFPTI_DIM(4); }
    else 
      {
        //bbtkGlobalError("GetImageTypeInfoFromPixelTypeInfo : itk::Images not compiled for dim "<<dim);
        return typeid(void);
      }
    return typeid(void);
  }


#undef BBTK_GITIFPTI_DIM


///
template <typename ValueType>
class TypeMapping
{
public:
  TypeMapping() {}

  template <typename T>
  ValueType& value()
  {
    return m_map[ (void*)typeid(T).name() ];
  }
  template <typename T>
  ValueType& operator[]( const T& )
  {
    return m_map[ (void*)typeid(T).name() ];
  }

  ValueType& operator[]( const std::type_info& t)
  {
    return m_map[ (void*)t.name() ];
  }
  
  unsigned int size() const { return m_map.size(); }

  typedef typename std::map<void*, ValueType>::const_iterator const_iterator;

  const_iterator begin() const { return m_map.begin(); }
  const_iterator end() const { return m_map.end(); }

protected:
  std::map<void*, ValueType> m_map;
};

#define BBTK_BUILD_ITK_IMAGE_FUNCTION_MAPPING(MAP,FUN)                         \
    MAP.value<bbtk::Image_int8_t_2_ptr>() = FUN<bbtk::Image_int8_t_2_ptr>;     \
    MAP.value<bbtk::Image_int16_t_2_ptr>() = FUN<bbtk::Image_int16_t_2_ptr>;   \
    MAP.value<bbtk::Image_int32_t_2_ptr>() = FUN<bbtk::Image_int32_t_2_ptr>;   \
    MAP.value<bbtk::Image_uint8_t_2_ptr>() = FUN<bbtk::Image_uint8_t_2_ptr>;   \
    MAP.value<bbtk::Image_uint16_t_2_ptr>() = FUN<bbtk::Image_uint16_t_2_ptr>; \
    MAP.value<bbtk::Image_uint32_t_2_ptr>() = FUN<bbtk::Image_uint32_t_2_ptr>; \
    MAP.value<bbtk::Image_float_2_ptr>() = FUN<bbtk::Image_float_2_ptr>;       \
    MAP.value<bbtk::Image_double_2_ptr>() = FUN<bbtk::Image_double_2_ptr>;     \
    MAP.value<bbtk::Image_int8_t_3_ptr>() = FUN<bbtk::Image_int8_t_3_ptr>;     \
    MAP.value<bbtk::Image_int16_t_3_ptr>() = FUN<bbtk::Image_int16_t_3_ptr>;   \
    MAP.value<bbtk::Image_int32_t_3_ptr>() = FUN<bbtk::Image_int32_t_3_ptr>;   \
    MAP.value<bbtk::Image_uint8_t_3_ptr>() = FUN<bbtk::Image_uint8_t_3_ptr>;   \
    MAP.value<bbtk::Image_uint16_t_3_ptr>() = FUN<bbtk::Image_uint16_t_3_ptr>; \
    MAP.value<bbtk::Image_uint32_t_3_ptr>() = FUN<bbtk::Image_uint32_t_3_ptr>; \
    MAP.value<bbtk::Image_float_3_ptr>() = FUN<bbtk::Image_float_3_ptr>;       \
    MAP.value<bbtk::Image_double_3_ptr>() = FUN<bbtk::Image_double_3_ptr>;     \
    MAP.value<bbtk::Image_int8_t_4_ptr>() = FUN<bbtk::Image_int8_t_4_ptr>;     \
    MAP.value<bbtk::Image_int16_t_4_ptr>() = FUN<bbtk::Image_int16_t_4_ptr>;   \
    MAP.value<bbtk::Image_int32_t_4_ptr>() = FUN<bbtk::Image_int32_t_4_ptr>;   \
    MAP.value<bbtk::Image_uint8_t_4_ptr>() = FUN<bbtk::Image_uint8_t_4_ptr>;   \
    MAP.value<bbtk::Image_uint16_t_4_ptr>() = FUN<bbtk::Image_uint16_t_4_ptr>; \
    MAP.value<bbtk::Image_uint32_t_4_ptr>() = FUN<bbtk::Image_uint32_t_4_ptr>; \
    MAP.value<bbtk::Image_float_4_ptr>() = FUN<bbtk::Image_float_4_ptr>;       \
    MAP.value<bbtk::Image_double_4_ptr>() = FUN<bbtk::Image_double_4_ptr>; 

  //=======================================================================


  //=======================================================================
  // Type traits ImagePointer to define bbtk::any<ImagePointer>
  /// The TypeTraits for all itk::Image pointer types 
  template <typename T> struct ImagePointer { static const bool value = false; };

  typedef bbtk::any<ImagePointer> anyImagePointer;

  // Specialisations for instantiated image types 
  // DIMENSION 2
#ifdef BBTK_ITK_IMAGE_DIM_2
#  ifdef BBTK_ITK_IMAGE_TYPE_int8_t 
  template <> struct ImagePointer<Image_int8_t_2_ptr> { static const bool value = true; };
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_int16_t 
  template <> struct ImagePointer<Image_int16_t_2_ptr> { static const bool value = true; };
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_int32_t 
  template <> struct ImagePointer<Image_int32_t_2_ptr> { static const bool value = true; };
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint8_t 
  template <> struct ImagePointer<Image_uint8_t_2_ptr> { static const bool value = true; };
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint16_t 
  template <> struct ImagePointer<Image_uint16_t_2_ptr> { static const bool value = true; };
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint32_t 
  template <> struct ImagePointer<Image_uint32_t_2_ptr> { static const bool value = true; };
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_float
  template <> struct ImagePointer<Image_float_2_ptr> { static const bool value = true; };
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_double
  template <> struct ImagePointer<Image_double_2_ptr> { static const bool value = true; };
#  endif
#endif



#ifdef BBTK_ITK_IMAGE_DIM_3
#  ifdef BBTK_ITK_IMAGE_TYPE_int8_t 
  template <> struct ImagePointer<Image_int8_t_3_ptr> { static const bool value = true; };
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_int16_t 
  template <> struct ImagePointer<Image_int16_t_3_ptr> { static const bool value = true; };
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_int32_t 
  template <> struct ImagePointer<Image_int32_t_3_ptr> { static const bool value = true; };
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint8_t 
  template <> struct ImagePointer<Image_uint8_t_3_ptr> { static const bool value = true; };
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint16_t 
  template <> struct ImagePointer<Image_uint16_t_3_ptr> { static const bool value = true; };
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint32_t 
  template <> struct ImagePointer<Image_uint32_t_3_ptr> { static const bool value = true; };
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_float
  template <> struct ImagePointer<Image_float_3_ptr> { static const bool value = true; };
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_double
  template <> struct ImagePointer<Image_double_3_ptr> { static const bool value = true; };
#  endif
#endif



#ifdef BBTK_ITK_IMAGE_DIM_4
#  ifdef BBTK_ITK_IMAGE_TYPE_int8_t 
  template <> struct ImagePointer<Image_int8_t_4_ptr> { static const bool value = true; };
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_int16_t 
  template <> struct ImagePointer<Image_int16_t_4_ptr> { static const bool value = true; };
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_int32_t 
  template <> struct ImagePointer<Image_int32_t_4_ptr> { static const bool value = true; };
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint8_t 
  template <> struct ImagePointer<Image_uint8_t_4_ptr> { static const bool value = true; };
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint16_t 
  template <> struct ImagePointer<Image_uint16_t_4_ptr> { static const bool value = true; };
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint32_t 
  template <> struct ImagePointer<Image_uint32_t_4_ptr> { static const bool value = true; };
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_float
  template <> struct ImagePointer<Image_float_4_ptr> { static const bool value = true; };
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_double
  template <> struct ImagePointer<Image_double_4_ptr> { static const bool value = true; };
#  endif
#endif


} // namespace bbitk

namespace bbtk
{
  BBTK_DEFINE_HUMAN_READABLE_TYPE_NAME(bbitk::anyImagePointer,"anyItkImagePointer");
//  BBTK_DEFINE_HUMAN_READABLE_TYPE_NAME(bbitk::Image_double_2_ptr,"itkImageDouble3ptr");
//  BBTK_DEFINE_HUMAN_READABLE_TYPE_NAME(bbitk::Image_double_3_ptr,"itkImageDouble3ptr");

 // Human readable names for itk images
// #define BBTK_HUMAN_READABLE_ITK_IMAGE_NAME(TYPE,DIM) std::string("itkImage")+HumanTypeName<TYPE>()+std::string(#DIM)+std::string("ptr")

#define BBTK_HUMAN_READABLE_ITK_IMAGE(TYPE,DIM)                                     \
template <> inline std::string HumanTypeName< bbitk::Image_##TYPE##_##DIM##_ptr >() \
  { std::string n("itkImage");                                                      \
	n+= HumanTypeName<TYPE>();                                                  \
 n += std::string(#DIM);                                                            \
n += std::string("ptr");                                                            \
	return n; }                                                                 \
    template <> inline std::string HumanTypeName< bbitk::Image_##TYPE##_##DIM##_ptr >(const bbitk::Image_##TYPE##_##DIM##_ptr &)	\
    { std::string n("itkImage");\
 n+= HumanTypeName<TYPE>(); \
	n += std::string(#DIM); \
n+= std::string("ptr"); \
	return n; }							\
template <> inline std::string HumanTypeName< bbitk::Image_##TYPE##_##DIM##_cptr >()		\
  { std::string n("itkImage"); \
	n+= HumanTypeName<TYPE>();\
 n += std::string(#DIM);\
n += std::string("cptr"); \
	return n; }							\
    template <> inline std::string HumanTypeName< bbitk::Image_##TYPE##_##DIM##_cptr >(const bbitk::Image_##TYPE##_##DIM##_cptr &)	\
    { std::string n("itkImage");\
 n+= HumanTypeName<TYPE>(); \
	n += std::string(#DIM); \
n+= std::string("cptr"); \
	return n; }

//BBTK_HUMAN_READABLE_ITK_IMAGE(int8_t,2);			

//  BBTK_DEFINE_HUMAN_READABLE_TYPE_NAME(bbitk::Image_##TYPE##_##DIM##_ptr,BBTK_HUMAN_READABLE_ITK_IMAGE_NAME(TYPE,DIM) )

	
#define BBTK_HUMAN_READABLE_ITK_IMAGES_DIM(DIM)	\
  BBTK_HUMAN_READABLE_ITK_IMAGE(int8_t,DIM);	\
    BBTK_HUMAN_READABLE_ITK_IMAGE(uint8_t,DIM);	\
    BBTK_HUMAN_READABLE_ITK_IMAGE(int16_t,DIM);	\
    BBTK_HUMAN_READABLE_ITK_IMAGE(uint16_t,DIM);\
    BBTK_HUMAN_READABLE_ITK_IMAGE(int32_t,DIM);	\
    BBTK_HUMAN_READABLE_ITK_IMAGE(uint32_t,DIM);\
    BBTK_HUMAN_READABLE_ITK_IMAGE(float,DIM);	\
    BBTK_HUMAN_READABLE_ITK_IMAGE(double,DIM)
  
  BBTK_HUMAN_READABLE_ITK_IMAGES_DIM(2);
  BBTK_HUMAN_READABLE_ITK_IMAGES_DIM(3);
  BBTK_HUMAN_READABLE_ITK_IMAGES_DIM(4);
  //BBTK_HUMAN_READABLE_ITK_IMAGES_DIM(5)
  

} // namespace bbtk

#endif
#endif
