/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbitkImageProperties.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:50:39 $
  Version:   $Revision: 1.11 $
=========================================================================*/



/**
 * \file 
 * \brief class ITKImageProperties : generic ITKImage reader
 */
/**
 * \class bbtk::ITKImageProperties
 * \brief Generic ITKImage reader
 */
#ifdef _USE_ITK_

#ifndef __bbtkITKImageProperties_h__
#define __bbtkITKImageProperties_h__

#include "bbtkAtomicBlackBox.h"
#include "bbitkImage.h"
#include "bbitkImageRegion.h"

namespace bbitk
{

  //=================================================================
  // BlackBox declaration
  class ImageProperties : public bbtk::AtomicBlackBox  
  {
    
    BBTK_BLACK_BOX_INTERFACE(ImageProperties,
			     bbtk::AtomicBlackBox);

    BBTK_DECLARE_INPUT(In,anyImagePointer);
    BBTK_DECLARE_OUTPUT(TypeName,std::string);
    BBTK_DECLARE_OUTPUT(Dimension,unsigned int);
    BBTK_DECLARE_OUTPUT(LargestPossibleRegion,anyImageRegion);
    BBTK_DECLARE_OUTPUT(Index,std::vector<int>);
    BBTK_DECLARE_OUTPUT(Size,std::vector<int>);
    BBTK_DECLARE_OUTPUT(Origin,std::vector<float>);
    BBTK_DECLARE_OUTPUT(Spacing,std::vector<double>);

	BBTK_DECLARE_OUTPUT(MinMax,std::vector<float>);
    BBTK_PROCESS(DoIt);
    void DoIt();

  private:
    // Template doit method 
    template<class ImageType> void DoIt();
  };
  //=================================================================

  //=================================================================
  // BlackBox description
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(ImageProperties,bbtk::AtomicBlackBox);
  BBTK_NAME("ImageProperties");
  BBTK_AUTHOR("laurent.guigues at creatis.insa-lyon.fr");
  BBTK_CATEGORY("image");
  BBTK_DESCRIPTION("Outputs different properties of an image (type, dimension, size, spacing, ...)");
  BBTK_INPUT(ImageProperties,In,"Input image",anyImagePointer,"");
  BBTK_OUTPUT(ImageProperties,TypeName,"Pixel type name",std::string,"pixel type");
  BBTK_OUTPUT(ImageProperties,Dimension,"Dimension",unsigned int,"image dimension");
  BBTK_OUTPUT(ImageProperties,LargestPossibleRegion,"Global extent of the image",anyImageRegion,"");
  BBTK_OUTPUT(ImageProperties,Index,"Index of the image",std::vector<int>,"image index");
  BBTK_OUTPUT(ImageProperties,Size,"Size in each dimension",std::vector<int>,"image size");
  BBTK_OUTPUT(ImageProperties,Origin,"Origin of the image",std::vector<float>,"image origin");
  BBTK_OUTPUT(ImageProperties,Spacing,"Size of the voxels",std::vector<double>,"voxel size");
  BBTK_OUTPUT(ImageProperties,MinMax,"Minimum and the maximum intensity values of an image",std::vector<float>,"");
  BBTK_END_DESCRIBE_BLACK_BOX(ImageProperties);
  //=================================================================

}
//namespace bbitk
#endif

#endif
