/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbitkImageRegion.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:50:39 $
  Version:   $Revision: 1.8 $
=========================================================================*/




#ifdef _USE_ITK_

#ifndef __bbitkImageRegion_h_INCLUDED__
#define __bbitkImageRegion_h_INCLUDED__

#include "itkImageRegion.h"
#include "bbtkMessageManager.h"
#include "bbtkAny.h"
#include "bbtkAtomicBlackBox.h"

namespace bbitk
{
  //=======================================================================
  /// Type traits ImageRegion to define bbtk::any<ImageRegion>
  template <typename T> struct ImageRegion { static const bool value = false; };
  // Specialisations for instantiated image types
#ifdef BBTK_ITK_IMAGE_DIM_2
  typedef itk::ImageRegion<2> ImageRegion_2;
  template <> struct ImageRegion<ImageRegion_2> { static const bool value = true; };
#endif
#ifdef BBTK_ITK_IMAGE_DIM_3
  typedef itk::ImageRegion<3> ImageRegion_3;
  template <> struct ImageRegion<ImageRegion_3> { static const bool value = true; };
#endif
#ifdef BBTK_ITK_IMAGE_DIM_4
  typedef itk::ImageRegion<4> ImageRegion_4;
  template <> struct ImageRegion<ImageRegion_4> { static const bool value = true; };
#endif

  /// 
  typedef bbtk::any<ImageRegion> anyImageRegion;
} // namespace bbitk
 
namespace bbtk
{
  /// Human readable name for bbtk::any<bbitk::ImageRegion>
  BBTK_DEFINE_HUMAN_READABLE_TYPE_NAME(bbitk::anyImageRegion,"anyItkImageRegion");
} // namespace bbtk



namespace bbitk
{
  //=======================================================================
  /// Black Box which creates an anyImageRegion
  class /*BBTK_EXPORT*/ ImageRegionCreator
    : public bbtk::AtomicBlackBox
  {
    BBTK_BLACK_BOX_INTERFACE(ImageRegionCreator,bbtk::AtomicBlackBox);
    BBTK_DECLARE_INPUT(Index,std::vector<long>);
    BBTK_DECLARE_INPUT(Size,std::vector<long>);
    BBTK_DECLARE_OUTPUT(Out,anyImageRegion);
    BBTK_PROCESS(DoIt);
  private:
    void DoIt();
    template <unsigned int Dimension> void DoItForDimension();
 };


  BBTK_BEGIN_DESCRIBE_BLACK_BOX(ImageRegionCreator,bbtk::AtomicBlackBox);
  BBTK_NAME("ImageRegion");
  BBTK_AUTHOR("laurent.guigues@creatis.insa-lyon.fr");
  BBTK_DESCRIPTION("Creates a generic ImageRegion ("+bbtk::TypeName<anyImageRegion>()+") from two vectors providing the index and size of the region. The dimension D of the actual itk::ImageRegion<D> created is the max of the sizes of Index and Size (the smallest vector is padded by zeros).");
  BBTK_CATEGORY("image");
	typedef std::vector<long> vectoroflong;
  BBTK_INPUT(ImageRegionCreator,Index,"Vector of region indices",
	     vectoroflong,"image index");
  BBTK_INPUT(ImageRegionCreator,Size,"Vector of region sizes",
	     vectoroflong,"image size");
  BBTK_OUTPUT(ImageRegionCreator,Out,"Output generic region",anyImageRegion,"");
  BBTK_END_DESCRIBE_BLACK_BOX(ImageRegionCreator);
  
} // namespace bbitk


#endif
#endif
