/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbitkImageWriter.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:50:39 $
  Version:   $Revision: 1.8 $
=========================================================================*/
                                                                       

/**
 * \file 
 * \brief class ITKImageWriter : generic ITKImage reader
 */
/**
 * \class bbtk::ITKImageWriter
 * \brief Generic ITKImage reader
 */
#ifdef _USE_ITK_

#ifndef __bbtkITKImageWriter_h__
#define __bbtkITKImageWriter_h__

#include "bbtkAtomicBlackBox.h"
#include "bbitkImage.h"

namespace bbitk
{

  //=================================================================
  // BlackBox declaration
  class ImageWriter : public bbtk::AtomicBlackBox  
  {
    
    BBTK_BLACK_BOX_INTERFACE(ImageWriter,
				  bbtk::AtomicBlackBox);

    BBTK_DECLARE_INPUT(Filename,std::string);
    BBTK_DECLARE_INPUT(In,anyImagePointer);
    BBTK_PROCESS(Write);
    void Write();

  private:
    // Template write method 
    template<class ImageType> void Write();
  };
  

  //=================================================================
  // BlackBox description
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(ImageWriter,bbtk::AtomicBlackBox);
  BBTK_NAME("ImageWriter");
  BBTK_AUTHOR("laurent.guigues at creatis.insa-lyon.fr");
  BBTK_DESCRIPTION("Generic itk image writer");
  BBTK_CATEGORY("image;read/write");
  BBTK_INPUT(ImageWriter,Filename,
	     "filename with complete path",std::string,"file name");
  BBTK_INPUT(ImageWriter,In,"Image to write",anyImagePointer,"");
  BBTK_END_DESCRIBE_BLACK_BOX(ImageWriter);
  //=================================================================
  

}
//namespace bbitk
#endif

#endif  // _USE_ITK_
