/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la SantÈ)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


/*=========================================================================
                                                                                
  Program:   bbtk
  Module:    $RCSfile: bbitkvtkvtkImageDataVector2itkImageVector.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:50:49 $
  Version:   $Revision: 1.2 $
 
                                                                                
=========================================================================*/
/**
 * \file 
 * \brief class vtkImageDataVector2itkImageVector : Converts a vtkImageData to a generic itkImage
 */
/**
 * \class vtkImageDataVector2itkImageVector 
 * \brief Converts a vtkImageData to a generic itkImage
 */
#ifdef _USE_ITK_
#ifdef _USE_VTK_

#ifndef __bbitkvtkvtkImageDataVector2itkImageVector_h__
#define __bbvitkvtktkImageData2itkImage_h__

#include "bbtkAtomicBlackBox.h"
#include "bbitkImage.h"
#include "vtkImageData.h"
#include "itkProcessObject.h"

namespace bbitkvtk
{

  class /*BBTK_EXPORT*/ vtkImageDataVector2itkImageVector : public bbtk::AtomicBlackBox  
  {
    
    BBTK_BLACK_BOX_INTERFACE(vtkImageDataVector2itkImageVector,
			     bbtk::AtomicBlackBox);

    BBTK_DECLARE_INPUT(In,std::vector<vtkImageData*>);
    BBTK_DECLARE_OUTPUT(Out,std::vector<bbitk::anyImagePointer>);
    BBTK_PROCESS(Convert);
    void Convert();

  private:
    // Convert method : template on type of the itk image to be created
    template<class T, unsigned int D> void Convert();
    // stores the pointer on the template itk::VTKImageToImageFilter 
    itk::ProcessObject::Pointer mConverter;
    std::vector<bbitk::anyImagePointer> m_Output_Vector;
  }; 
  

  //=================================================================
  // AtomicBlackBox description
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(vtkImageDataVector2itkImageVector,bbtk::AtomicBlackBox);
  BBTK_NAME("vtkImageDataVector2itkImageVector");
  BBTK_AUTHOR("jpr@creatis.insa-lyon.fr");
  BBTK_DESCRIPTION("Converts a std::vector of vtkImageData* to a std::vector of generic itkImage pointer");
  BBTK_DEFAULT_ADAPTOR();
  BBTK_INPUT(vtkImageDataVector2itkImageVector,In,
	     "Input std::vector of vtkImageData*",std::vector<vtkImageData*>,"");
  BBTK_OUTPUT(vtkImageDataVector2itkImageVector,Out,
	      "Output std::vector of generic itkImage pointer",
	      std::vector<bbitk::anyImagePointer>,"");
  BBTK_END_DESCRIBE_BLACK_BOX(vtkImageDataVector2itkImageVector);
  //=================================================================


}
//namespace bbitkvtk
#endif
// _USE_VTK_
#endif
// _USE_ITK_

#endif
