/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbstdExecBbiCommand.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:32 $
  Version:   $Revision: 1.8 $
=========================================================================*/


#ifndef __bbstdExecBbiCommand_h_INCLUDED__
#define __bbstdExecBbiCommand_h_INCLUDED__

#include "bbtkAtomicBlackBox.h"
#include "bbstd_EXPORT.h"

namespace bbstd
{

  class bbstd_EXPORT ExecBbiCommand
    : 
  public bbtk::AtomicBlackBox
  {
  public:
    BBTK_BLACK_BOX_INTERFACE(ExecBbiCommand,bbtk::AtomicBlackBox);
    BBTK_DECLARE_INPUT(In,std::string);
    BBTK_PROCESS(DoProcess);
    void DoProcess();
  };

  BBTK_BEGIN_DESCRIBE_BLACK_BOX(ExecBbiCommand,bbtk::AtomicBlackBox);
  BBTK_NAME("ExecBbiCommand");
  BBTK_AUTHOR("eduardo.davila@creatis.insa-lyon.fr");
  BBTK_DESCRIPTION("Executes bbi commands");
  BBTK_INPUT(ExecBbiCommand,In,"bbi commands separated by ';' , use '' to indicate strings ex. help 'graph' ",std::string,"");  
  BBTK_END_DESCRIBE_BLACK_BOX(ExecBbiCommand);

} // EO namespace bbstd

#endif //  __bbstdExecBbiCommand_h_INCLUDED__

