/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#ifndef __bbstdGetIntervalNumberFromIntervalList_h_INCLUDED__
#define __bbstdGetIntervalNumberFromIntervalList_h_INCLUDED__
#include "bbstd_EXPORT.h"
#include "bbtkAtomicBlackBox.h"

namespace bbstd
{

class bbstd_EXPORT GetIntervalNumberFromIntervalList
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(GetIntervalNumberFromIntervalList,bbtk::AtomicBlackBox);

  BBTK_DECLARE_INPUT(Value, double);
  BBTK_DECLARE_INPUT(IntervalList, std::vector<double>);
  BBTK_DECLARE_INPUT(ErrorValue, double);

  BBTK_DECLARE_OUTPUT(IntervalNumber, int);

  BBTK_PROCESS(Process);
  void Process();
};

   BBTK_BEGIN_DESCRIBE_BLACK_BOX(GetIntervalNumberFromIntervalList,bbtk::AtomicBlackBox);
   BBTK_NAME("GetIntervalNumberFromIntervalList");
   BBTK_AUTHOR("Claire Mouton");
   BBTK_DESCRIPTION("Providing a value and a list of intervals, the box returns the first interval number containing the input value. Interval numbers start at 0.");
   BBTK_CATEGORY("");
   BBTK_INPUT(GetIntervalNumberFromIntervalList,Value,"The value to be looked for in the interval list.",double,"");
   BBTK_INPUT(GetIntervalNumberFromIntervalList,IntervalList,"Interval List provided as a list of double values corresponding to intervals. For example, '0 10 20 50' corresponds to the three following intervals 0/[0; 10[  1/[10; 20[  2/[20; 50[.",std::vector<double>,"");
   BBTK_INPUT(GetIntervalNumberFromIntervalList,ErrorValue,"The output value returned if the value is not in any interval (default is -1).",double,"");
   BBTK_OUTPUT(GetIntervalNumberFromIntervalList,IntervalNumber,"The (first) interval number containing the input value. If the value is not in any interval, the output is set to the ErrorValue (default is -1).",int,"");

BBTK_END_DESCRIBE_BLACK_BOX(GetIntervalNumberFromIntervalList);
}
// EO namespace bbstd

#endif // __bbstdGetIntervalNumberFromIntervalList_h_INCLUDED__

