/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbstdStringSelect.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:32 $
  Version:   $Revision: 1.9 $
=========================================================================*/

#ifndef __bbstdStringSelect_h_INCLUDED__
#define __bbstdStringSelect_h_INCLUDED__

#include "bbtkAtomicBlackBox.h"
#include "bbstd_EXPORT.h"

namespace bbstd
{
  //=======================================================================
  class bbstd_EXPORT StringSelect
    : 
    public bbtk::AtomicBlackBox
  {
    BBTK_BLACK_BOX_INTERFACE(StringSelect,bbtk::AtomicBlackBox);
    BBTK_DECLARE_INPUT(In,int);
    BBTK_DECLARE_INPUT(In0,std::string);
    BBTK_DECLARE_INPUT(In1,std::string);
    BBTK_DECLARE_INPUT(In2,std::string);
    BBTK_DECLARE_INPUT(In3,std::string);
    BBTK_DECLARE_INPUT(In4,std::string);
    BBTK_DECLARE_INPUT(In5,std::string);
    BBTK_DECLARE_INPUT(In6,std::string);
    BBTK_DECLARE_INPUT(In7,std::string);
    BBTK_DECLARE_INPUT(In8,std::string);
    BBTK_DECLARE_INPUT(In9,std::string);
    BBTK_DECLARE_OUTPUT(Out,std::string);
    BBTK_PROCESS(DoProcess);
    void DoProcess();
  };
  //=======================================================================

  //=======================================================================
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(StringSelect,bbtk::AtomicBlackBox);
  BBTK_NAME("StringSelect");
  BBTK_AUTHOR("eduardo.davila@creatis.insa-lyon.fr");
  BBTK_CATEGORY("misc");
  BBTK_DESCRIPTION("Outputs the string set to the ith input Ini (In0 ... In9) according to the value of the input In, hence selects a string according to an index.");
  BBTK_INPUT(StringSelect,In,"Index of the string to select",int,"");
  BBTK_INPUT(StringSelect,In0,"String of index 0",std::string,"");
  BBTK_INPUT(StringSelect,In1,"String of index 1",std::string,"");
  BBTK_INPUT(StringSelect,In2,"String of index 2",std::string,"");
  BBTK_INPUT(StringSelect,In3,"String of index 3",std::string,"");
  BBTK_INPUT(StringSelect,In4,"String of index 4",std::string,"");
  BBTK_INPUT(StringSelect,In5,"String of index 4",std::string,"");
  BBTK_INPUT(StringSelect,In6,"String of index 6",std::string,"");
  BBTK_INPUT(StringSelect,In7,"String of index 7",std::string,"");
  BBTK_INPUT(StringSelect,In8,"String of index 8",std::string,"");
  BBTK_INPUT(StringSelect,In9,"String of index 9",std::string,"");
  BBTK_OUTPUT(StringSelect,Out,"Selected string",std::string,"");
  BBTK_END_DESCRIBE_BLACK_BOX(StringSelect);
  //=======================================================================

}
// EO namespace bbstd

#endif //  __bbstdStringSelect_h_INCLUDED__


