/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkAtomicBlackBoxOutputDescriptor.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.4 $
=========================================================================*/

                                                                        


/**
 *  \file 
 *  \brief Class bbtk::AtomicBlackBoxOutputDescriptor : structure containing the description of a AtomicBlackBox output (name, description, type, functor)
 */
/**
 * \class bbtk::AtomicBlackBoxOutputDescriptor
 * \brief Structure containing the description of a AtomicBlackBox output (name, description, type, functor)
 */

#ifndef __bbtkAtomicBlackBoxOutputDescriptor_h__
#define __bbtkAtomicBlackBoxOutputDescriptor_h__

#include "bbtkBlackBoxOutputDescriptor.h"
#include "bbtkAtomicBlackBoxGetSetFunctor.h"
#include "bbtkMessageManager.h"

namespace bbtk
{


  class BBTK_EXPORT AtomicBlackBoxOutputDescriptor : 
    public bbtk::BlackBoxOutputDescriptor
  {
  public:
      
    AtomicBlackBoxOutputDescriptor( TypeInfo creator_type_info,
				    const std::string& name,
				    const std::string& description,
				    const std::string& nature,
				    AtomicBlackBoxGetFunctor* getfunctor,
				    AtomicBlackBoxSetFunctor* setfunctor,
				    bool copy_construct = true);
    ~AtomicBlackBoxOutputDescriptor();
    
    /// Returns the type of the input
    TypeInfo GetTypeInfo() const { return mGetFunctor->GetTypeInfo(); }
    /// Returns the name of the type of the input
    std::string GetTypeName() const { return mGetFunctor->GetTypeName(); }
   /// Returns the name of the type of the input
    std::string GetHumanTypeName() const { return mGetFunctor->GetHumanTypeName(); }
    /// Returns true iff the type is a pointer to class 
    virtual bool IsPointerType() const { return mGetFunctor->IsPointerType(); }   /// Returns the functor on the Get method
    AtomicBlackBoxGetFunctor* GetGetFunctor() { return mGetFunctor; }
    /// Returns the functor on the Set method
    AtomicBlackBoxSetFunctor* GetSetFunctor() { return mSetFunctor; }
    
    
  private:
    /// Default ctor is private 
    AtomicBlackBoxOutputDescriptor() : 
      BlackBoxOutputDescriptor(typeid(void),"","","") {}
    /// The functor on the Get method
    AtomicBlackBoxGetFunctor* mGetFunctor;
    /// The functor on the Set method
    AtomicBlackBoxSetFunctor* mSetFunctor;
  };

  
}
// namespace bbtk
#endif
