/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkBlackBoxOutputConnector.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.11 $
=========================================================================*/

                                                                       


/**
 *  \file 
 *  \brief Class bbtk::BlackBoxOutputConnector : 
 */
/**
 * \class bbtk::BlackBoxOutputConnector
 * \brief 
 */
 
#ifndef __bbtkBlackBoxOutputConnector_h__
#define __bbtkBlackBoxOutputConnector_h__

#include "bbtkPimpl.h"
#include "bbtkConnection.h"
#include "bbtkBlackBox.h"
#include "bbtkMessageManager.h"
#include <vector>


namespace bbtk
{

 
  class BBTK_EXPORT BlackBoxOutputConnector 
  {
  public:
 
  
    typedef BlackBox::OutputChangeCallbackType OutputChangeCallbackType;

    /// Ctor
    BlackBoxOutputConnector(BlackBoxPointer b);
    /// Dtor
    ~BlackBoxOutputConnector();

    /// Sets a connection
    void SetConnection(Connection* c);
    /// Unsets the connection 
    void UnsetConnection(Connection* c);
    /// The type of vector of output connections
    typedef std::vector<Connection*> ConnectionVector;
    /// Returns the vector of connection plugged into this output (const)
    const ConnectionVector& GetConnectionVector() const;
    
    /// Returns the status of the input 
    IOStatus GetStatus() const;
    /// Sets the status of the input 
    void SetStatus( IOStatus s );
    
    /// Signals the change observers that the output has changed
    void SignalChange( BlackBox::Pointer box, const std::string& output );


    /// Adds the function f to the list of functions to call when 
    /// the output changes.
    void AddChangeObserver(OutputChangeCallbackType f); 

    /// Removes the function f from the list of functions to call when 
    /// the output changes (TO WRITE)
    void RemoveChangeObserver(OutputChangeCallbackType f); 

      /// Private implementation
    BBTK_DECLARE_PIMPL(BlackBoxOutputConnector);
    
  private:
    /// Purposedly not implemented
    BlackBoxOutputConnector(const BlackBoxOutputConnector&);

  };
  
}
// namespace bbtk
#endif
