/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkKW.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.2 $
=========================================================================*/



#ifndef __bbtkKW_h_INCLUDED__
#define __bbtkKW_h_INCLUDED__

//===========================================================================
#ifdef USE_KWWIDGETS


// KW headers
//#include <vtkKWWidget.h>
//#include <vtkKWWindowBase.h>



//===========================================================================

//===========================================================================
#include "bbtkSystem.h"
#include "vtkKWApplication.h"
//===========================================================================

//===========================================================================
// SIGNAL/SLOT MECHANISM 
// FOR bbtk WINDOWS CREATION/DESTRUCTION OBSERVATION 
// BBTKKWSIG
#include <boost/signals2/signal.hpp>
#include <boost/bind.hpp>
// \BBTKKWSIG
//===========================================================================

namespace bbtk
{

  //==================================================================
  /// Global KWWidgets handlers (application, cursor...)
  
// BBTKKWSIG
#define bbtkAddKWSignalObserver(METHOD)		\
  KW::AddSignalObserver(boost::bind(&METHOD, this))
// \BBTKKWSIG

#define BBTK_KW_BUSY_CURSOR bbtk::KW::BusyCursor __bbtk_dummy_busy_cursor;

  struct BBTK_EXPORT KW
  {	
  public:
    // BBTKKWSIG
    typedef boost::signals2::signals::trackable SignalObserver;
    typedef boost::signals2::signal<void ()>  Signal_type;
    typedef Signal_type::slot_function_type Slot_function_type;
    // \BBTKKWSIG
    
    static vtkKWApplication* GetApplication();
    
    /*
    static void ResetCursor();
    static void BeginBusyCursor(); 
    static void EndBusyCursor();
    */

    //    static void LoopUntilAllWindowsClose();

    class BusyCursor
    {
    public:
      BusyCursor();
      ~BusyCursor();
      //      wxBusyCursor* mCursor;
    };

    //    static void SetTopWindowParent(vtkKWWidget*);
    static void SetAutoDestroyTopWindow(bool);

    /// Returns the creation time parent of all bbtk windows 
    /// (window can be reparented after creation)
    //    static vtkKWWindowBase* GetTopWindow();
    //    static bool TopWindowExists();
    
    static void IncNbWindowsAlive();
    static void DecNbWindowsAlive();
    static int  GetNbWindowsAlive();
    static bool IsSomeWindowAlive();
    
    static void IncNbWindowsShown();
    static void DecNbWindowsShown();
    static int  GetNbWindowsShown();
    static bool IsSomeWindowShown();

    // BBTKKWSIG
    static void AddSignalObserver(Slot_function_type);
    // \BBTKKWSIG
    
  private:
    
    static void CreateKWAppIfNeeded();
    static void DestroyKWAppIfNeeded();
    
    //    static void CreateTopWindowIfNeeded();
    //    static void DestroyTopWindowIfNeeded();
    
    /// Sets the creation time parent of all bbtk windows
    //    static void SetTopWindow(vtkKWWindowBase*);
    
  }; 
  // struct KW
  //==================================================================
  


  
} // namespace bbtk
  
#endif // EO USE_KWWIDGETS
#endif // EO __bbtkKW_h_INCLUDED__
