/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkQtBlackBox.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.3 $
========================================================================*/


/**
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
 */
/**
 * \file 
 * \brief 
 */
/**
 * \class bbtk::
 * \brief 
 */
#ifndef __bbtkQtBlackBox_h_INCLUDED__
#define __bbtkQtBlackBox_h_INCLUDED__


#ifdef USE_QT


#include "bbtkWidgetBlackBox.h"


#include "bbtkQt.h"


//==================================================================
class QWidget;
//==================================================================


namespace bbtk
{





  //==================================================================
  /// Widget black boxes
  class BBTK_EXPORT QtBlackBox : public bbtk::WidgetBlackBox<QWidget>
  { 
    BBTK_BLACK_BOX_INTERFACE(QtBlackBox,bbtk::WidgetBlackBox<QWidget>);
  public:
   //==================================================================    
    /// Callback for creating a Dialog window (modal)
    /// ** Must be defined ** in toolkit specific descendants 
    virtual void bbCreateDialogWindow();
    //==================================================================    

    //==================================================================    
    /// Callback for creating a Frame window 
    /// ** Must be defined ** in toolkit specific descendants 
    virtual void bbCreateFrameWindow();
    //==================================================================    

   //==================================================================    
    QWidget* bbGetWindow() { return bbmWindow; }
    void bbSetWindow(QWidget*) ;
    bool bbWindowIsCreated() { return (bbGetWindow() != 0); }
    //==================================================================    


    //==================================================================    
    virtual void bbShowWindow();
    //==================================================================   
 
    //==================================================================    
    virtual void bbDestroyWindow();
    //==================================================================    

  private:

    QWidget* bbmWindow;
    
    //==================================================================
    //    virtual void InitWindowManagerIfNeeded();
    virtual void IncNbWindowsAlive();
    virtual void DecNbWindowsAlive();
    virtual int  GetNbWindowsAlive();
    virtual bool IsSomeWindowAlive();
    
    virtual void IncNbWindowsShown();
    virtual void DecNbWindowsShown();
    virtual int  GetNbWindowsShown();
    virtual bool IsSomeWindowShown();
    //==================================================================

  };
  //=================================================================
 

 //=================================================================
  // QtBlackBoxDescriptor declaration
  //
  class QtBlackBoxDescriptor : public WidgetBlackBoxDescriptor<QWidget>
  BBTK_BEGIN_DESCRIBE_BLACK_BOX_BODY(QtBlackBox);
  BBTK_NAME("QtBlackBox");
  BBTK_END_DESCRIBE_BLACK_BOX(QtBlackBox);
  //=================================================================



} //namespace bbtk



#endif  // USE_QT
#endif  //__bbtkQtBlackBox_h__
