/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkVtkBlackBoxMacros.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.15 $
=========================================================================*/





/**
 *  \file 
 *  \brief Defines macros for the creation of vtk object inherited black boxes
 */
#ifndef __bbtkVtkBlackBoxMacros_h__
#define __bbtkVtkBlackBoxMacros_h__
#include <vtkGarbageCollector.h>
//#include <vtkObjectFactory.h>
#include <vtkDebugLeaks.h>


//===========================================================================
//============================================================================
// VTK Specific macros
//===========================================================================
//===========================================================================

//===========================================================================
#define BBTK_VTK_BLACK_BOX_INTERFACE(CLASS,PARENTBLACKBOX,VTKOBJECT)	\
  BBTK_BLACK_BOX_INTERFACE(CLASS,PARENTBLACKBOX);			\
  typedef VTKOBJECT bbVtkObject;					\
  bbVtkObject* bbGetVtkObject() { return mVtkObject; }			\
  private:								\
  bbVtkObject *mVtkObject;						

//===========================================================================
#define BBTK_VTK_SET_DEFAULT_VALUES()		\
  mVtkObject = bbVtkObject::New();
//  mVtkObject = NULL;

//===========================================================================
#define BBTK_VTK_INITIALIZE_PROCESSING()	\
  mVtkObject = mVtkObject;
//  mVtkObject = bbVtkObject::New();

//===========================================================================
#define BBTK_VTK_FINALIZE_PROCESSING()		\
  if (mVtkObject) { mVtkObject->Delete(); mVtkObject = NULL; }

/*
//===========================================================================
#define BBTK_VTK_DELETE()						\
  int bbDelete() {							\
    for (int i=0; i<mVtkObject->GetNumberOfInputPorts();++i)		\
    mVtkObject->SetInput(i,0);						\
    bbGetOutputOut()->SetSource(NULL);					\
    int refs = mVtkObject->GetReferenceCount()-1;					\
    mVtkObject->Delete();						\
    return refs;							\
  }

//    bbmDescriptorPointer.reset();		
//===========================================================================
*/


//===========================================================================
/// Declares a vtkImageAlgorithm-inherited AtomicBlackBox input 
#define BBTK_DECLARE_VTK_IMAGE_ALGORITHM_INPUT(NAME,TYPE)		\
  public:								\
  TYPE bbGetInput##NAME ()						\
  { if (mVtkObject) return mVtkObject->GetImageDataInput(0); return 0; } \
  void bbSetInput##NAME (TYPE d)					\
  { if (mVtkObject) mVtkObject->SetInput( (vtkDataObject*) d); }

//===========================================================================

//===========================================================================
/// Declares a vtkPolyDataAlgorithm-inherited AtomicBlackBox input 
#define BBTK_DECLARE_VTK_POLY_DATA_ALGORITHM_INPUT(NAME,TYPE)		\
  public:								\
  TYPE bbGetInput##NAME ()						\
  { if (mVtkObject) return mVtkObject->GetPolyDataInput(0); return 0; } \
  void bbSetInput##NAME (TYPE d)					\
  { if (mVtkObject) mVtkObject->SetInput( (vtkDataObject*) d); }

//===========================================================================

//===========================================================================
/// Declares a vtkImageAlgorithm-inherited AtomicBlackBox output 
#define BBTK_DECLARE_VTK_OUTPUT(NAME,TYPE)				\
  public:								\
  TYPE bbGetOutput##NAME ()						\
  { if (mVtkObject) return mVtkObject->GetOutput(); return 0; }		\
  void bbSetOutput##NAME (TYPE d) 					\
  { }					
//===========================================================================

//===========================================================================
/// Declares a vtkAlgorithm-inherited AtomicBlackBox input 
#define BBTK_DECLARE_VTK_INPUT(NAME,TYPE)				\
  public:								\
  TYPE bbGetInput##NAME ()						\
  { if (mVtkObject) return dynamic_cast<TYPE>(mVtkObject->GetInput());	\
    return 0;}								\
  void bbSetInput##NAME (TYPE d)					\
  { if (mVtkObject)  mVtkObject->SetInput( (vtkDataObject*) d); }

//===========================================================================

//===========================================================================
/// Declares an AtomicBlackBox input corresponding to an 
/// inherited vtk parameter
/// which was declared by vtkSetMacro/vtkGetMacro
/// The NAME **MUST** be the same than the vtk parameter name
#define BBTK_DECLARE_VTK_PARAM(NAME,TYPE)			\
  public:								\
  TYPE bbGetInput##NAME ()						\
  { if (mVtkObject) return mVtkObject->Get##NAME(); return 0; }		\
  void bbSetInput##NAME (TYPE d)					\
  { if (mVtkObject) mVtkObject->Set##NAME(d);				\
  }
//===========================================================================

//===========================================================================
/// Declares an AtomicBlackBox input corresponding to an 
/// inherited vtk parameter
/// which was declared by vtkSetMacro/vtkGetMacro
/// The NAME **MUST** be the same than the vtk parameter name
/*
#define BBTK_DECLARE_VTK_2_PARAM(NAME,TYPE)		\
  public:								\
  TYPE bbGetInput##NAME ()						\
  {
  TO DO : HOW TO RECOMPOSE A VECTOR ?
  { return mVtkObject->Get##NAME(); }					\
  void bbSetInput##NAME (TYPE d)					\
  { 
  mVtkObject->Set##NAME(d[0],d[1]);		\
}
*/
//===========================================================================


//============================================================================
/// Defines the default bbUserProcess method for vtk inherited black boxes
/// (calls vtkParent::Update)
#define BBTK_VTK_PROCESS()						\
  public:								\
  inline void bbUserProcess()						\
  {									\
    bbtkBlackBoxDebugMessage("process",1,"**> Processing..."		\
			     <<std::endl);				\
    mVtkObject->Update();	\
printf("EED Process %s\n", bbGetFullName().c_str() ); \
  vtkIndent indent(2); \
   mVtkObject->PrintSelf(std::cout, indent ); \
    bbtkBlackBoxDebugMessage("process",2,"<** Processing"		\
			     <<std::endl);				\
  }
//============================================================================


//===========================================================================
/// EOF
//===========================================================================
#endif
