/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkWxGUITextEditor.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.11 $
=========================================================================*/




/**
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
 */
/**
 * \file 
 * \brief 
 */
/**
 * \class bbtk::
 * \brief 
 */


#ifdef _USE_WXWIDGETS_

	
#ifndef __bbtkWxGUITextEditor_h__
#define __bbtkWxGUITextEditor_h__


#include "bbtkWx.h"

#include "bbtkInterpreter.h"
#include <wx/splitter.h>
#include <wx/aui/aui.h>

#include "bbtkWxGUICommand.h"

namespace bbtk
{

  class WxTextCtrlGettingKeyEvents;
//   typedef wxTextCtrl WxTextCtrlGettingKeyEvents;
	class WxGUITextEditor;
 

  /// Abstract class which defines the callbacks invoked by WxGUITextEditor
  class BBTK_EXPORT WxGUITextEditorUser
  {
  public:
    WxGUITextEditorUser() {}
    virtual ~WxGUITextEditorUser() {}
    /// Callback invoked when the 'run' button is pressed
    virtual void WxGUITextEditorRun() {}
    virtual void WxGUITextEditorRunBBI() {} 
	virtual void WxGUITextEditorGraphSimple() {}
	virtual void WxGUITextEditorGraphDetail() {}
	  
  };

  //================================================================
  class WxGUITextEditorPage : public wxPanel
  {
  public:
    WxGUITextEditorPage(wxWindow* parent, WxGUITextEditor* editor);
    ~WxGUITextEditorPage();

    void SetPageName(const std::string& name) { mName = name; }
    const std::string& GetPageName() const { return mName; }

    bool AskFilename() const { return mAskFilename; }
    void SetAskFilename(bool a) { mAskFilename=a; }

    WxTextCtrlGettingKeyEvents* GetTextCtrl() { return mwxInputText; }

    void Load(const std::string& filename);
    void Save(const std::string& filter);
	void SaveFile(const std::string& filename);

	  
    bool IsModified(); //{ return mwxInputText->IsModified(); }
   
    std::string GetText();

  private:
    WxGUITextEditor* mEditor;
    WxTextCtrlGettingKeyEvents* mwxInputText;
    wxTextAttr* mwxInputTextAttr;
	wxFont* mFixedFont;
    std::string mName;
    bool mAskFilename;

    /*
    enum
    {
      ID_InputText
    };
    */
    //DECLARE_EVENT_TABLE();

  } ;
  //================================================================



  /// A text editor panel
  class BBTK_EXPORT WxGUITextEditor : public wxPanel
  {
  public:
    WxGUITextEditor( wxWindow *parent, WxGUITextEditorUser* user = 0 );
    ~WxGUITextEditor();

    void OnKeyDown(wxKeyEvent& event);
    void OnKeyUp(wxKeyEvent& event);

    void OnToolLeftClick(wxCommandEvent& event);
    void OnToolRightClick(wxCommandEvent& event);

    void OnPageClose(wxAuiNotebookEvent& evt);

    void New();
    void Open();
    void Open(const std::string& filename);
    void SaveCurrentPage();
    bool CloseCurrentPage();
    bool CloseAllPages();
    //   void Run();
    //    void Quit();

    void HighlightSyntax();
    void UpdateInfo();

    void NewPage(const std::string& filename);
    WxGUITextEditorPage* GetCurrentPage();
    void FocusOnCurrentPage();

    void SetFileNameFilter(const std::string& filter)
    { mFileNameFilter = filter; }

  private:
    WxGUITextEditorUser* mUser;

//    wxAuiManager m_mgr;
//    wxAuiNotebook*
	wxNotebook* mwxNotebook;
 
    wxToolBar* mwxToolBar;

    wxStaticText* mwxPosition;

    std::string mFileNameFilter;

   public:
	  
     enum
    {
      ID_ButtonNew,
      ID_ButtonOpen,
      ID_ButtonClose,
      ID_ButtonSave,
      ID_ButtonSaveAs,
      ID_ButtonRun,
	  ID_ButtonRunBBI,
	  ID_ButtonGraphSimple,
	  ID_ButtonGraphDetail
      //      ID_ButtonQuit
    };
    
    DECLARE_EVENT_TABLE()
	
  };

  
  /// Editor in a frame 
  class BBTK_EXPORT WxGUITextEditorWindow : public wxFrame
					      //, public WxGUICommandUser
  {
  public:
    WxGUITextEditorWindow( wxWindow *parent, wxString title, wxSize size);
    ~WxGUITextEditorWindow();
    void Open(const std::string& filename) { mEditor->Open(filename); }
    //    void WxGUICommandEnter(const std::string& s);


  private :
    
    WxGUITextEditor* mEditor;
  };
  

} // namespace bbtk


#endif // __bbtkWxGUITextEditor_h__

#endif //_USE_WXWIDGETS_
