/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbvtkImagePlanes.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:58 $
  Version:   $Revision: 1.25 $
=========================================================================*/

/**
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
 */
/**
 * \file 
 * \brief Pattern for the definition of a new type of Node (header)
 */
/**
 * \class bbtk::NodePatern 
 * \brief Pattern for the definition of a new type of Node 
 */
#ifdef _USE_VTK_


#ifndef __bbvtkImagePlanes_h_INCLUDED__
#define __bbvtkImagePlanes_h_INCLUDED__

#include "bbtkAtomicBlackBox.h"

class vtkImageData;
class vtkImagePlaneWidget;

#include "vtkPlaneWidget.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkImageReslice.h"
#include <vtkTransform.h>

namespace bbvtk
{
  typedef std::vector<double> winLevel;
  
  class /*BBTK_EXPORT*/ ImagePlanes : public bbtk::AtomicBlackBox
  { 
  public:
    BBTK_BLACK_BOX_INTERFACE(ImagePlanes,bbtk::AtomicBlackBox);
    //    BBTK_DECLARE_INPUT(Contour, int);
    BBTK_DECLARE_INPUT(In,             vtkImageData*);
    BBTK_DECLARE_INPUT(WindowLevel,    winLevel);
    BBTK_DECLARE_INPUT(PointsX,        std::vector<int>);
    BBTK_DECLARE_INPUT(PointsY,        std::vector<int>);
    BBTK_DECLARE_INPUT(PointsZ,        std::vector<int>);
    BBTK_DECLARE_INPUT(Interactor,	   vtkRenderWindowInteractor*);
	BBTK_DECLARE_INPUT(Interpolation,  int);

    BBTK_DECLARE_OUTPUT(PlaneX,			vtkImagePlaneWidget*);
    BBTK_DECLARE_OUTPUT(PlaneY,			vtkImagePlaneWidget*);
    BBTK_DECLARE_OUTPUT(PlaneZ,			vtkImagePlaneWidget*);
    BBTK_DECLARE_OUTPUT(Plane3Pts,		vtkInteractorObserver*);
    BBTK_DECLARE_OUTPUT(ImageX,			vtkImageData*);
    BBTK_DECLARE_OUTPUT(ImageY,			vtkImageData*);        
    BBTK_DECLARE_OUTPUT(ImageZ,			vtkImageData*);  
    BBTK_DECLARE_OUTPUT(Image3Pts,		vtkImageData*);   	
    BBTK_DECLARE_OUTPUT(Transform3Pts, vtkLinearTransform*);

    BBTK_PROCESS(Process);
    void Process();
    
	  
	vtkTransform *_imageTransform;

	  
  protected:

  private:
    class VtkCallbackType;
    VtkCallbackType* mVtkCallback;
    vtkImageData* image;
    vtkImageReslice* _imageReslicer;

    vtkTransform* _transform;
    vtkMatrix4x4* _matrix;

    double* getCrossProduct(double* vect0,double* vect1);
    double getPodoubleProduct(double* vect0,double* vect1);
    double* getNormal(double* vect);
    double getMagnitud(double* vect);
    double* makeVector(double podouble0[3], double podouble1[3]);
    void updateInteractor();

    vtkImagePlaneWidget* GetPlaneWidget(unsigned char activationkey, double r, double g, double b, vtkCellPicker* picker);
  };
   
  //=================================================================
  // UserBlackBox description
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(ImagePlanes,bbtk::AtomicBlackBox);
  BBTK_NAME("ImagePlanes");
  BBTK_AUTHOR("laurent.guigues@creatis.insa-lyon.fr");
  BBTK_DESCRIPTION("Creates three 3D planes with the input image mapped onto which the user can interact with. The output vtkImagePlaneWidget objects are to be inserted into a 3D scene (e.g. a Viewer3D)");
  BBTK_CATEGORY("3D object creator");
  
  BBTK_INPUT(ImagePlanes, In,          "Input Image",  vtkImageData *,   "");
  BBTK_INPUT(ImagePlanes, WindowLevel, "Widdow Level", winLevel,         "");
  BBTK_INPUT(ImagePlanes, PointsX,     "Points in X",  std::vector<int>, "");
  BBTK_INPUT(ImagePlanes, PointsY,     "Points in Y",  std::vector<int>, "");
  BBTK_INPUT(ImagePlanes, PointsZ,     "Points in Z",  std::vector<int>, "");
  BBTK_INPUT(ImagePlanes, Interactor,  "Interactor for the planes",  vtkRenderWindowInteractor*, "");
  BBTK_INPUT(ImagePlanes, Interpolation,  "Interpolation (default 1)  0=NEAREST_RESLICE  1=LINEAR_RESLICE  2=CUBIC_RESLICE",  int, "");

	
  BBTK_OUTPUT(ImagePlanes,PlaneX,    "The image plane in X direction",         vtkImagePlaneWidget*,   "");
  BBTK_OUTPUT(ImagePlanes,PlaneY,    "The image plane in Y direction",         vtkImagePlaneWidget*,   "");
  BBTK_OUTPUT(ImagePlanes,PlaneZ,    "The image plane in Z direction",         vtkImagePlaneWidget*,   "");
  BBTK_OUTPUT(ImagePlanes,Plane3Pts, "The image plane (3 points definition) ", vtkInteractorObserver*, "");
  BBTK_OUTPUT(ImagePlanes,ImageX,    "The image in X direction",               vtkImageData*,          "");
  BBTK_OUTPUT(ImagePlanes,ImageY,    "The image in Y direction",               vtkImageData*,          "");
  BBTK_OUTPUT(ImagePlanes,ImageZ,    "The image in Z direction",               vtkImageData*,          "");    
  BBTK_OUTPUT(ImagePlanes,Image3Pts, "The image (3 points plane definition)",  vtkImageData*,          "");    
  BBTK_OUTPUT(ImagePlanes,Transform3Pts, "The Tranform of the image",          vtkLinearTransform*,    "");    
     
 
  BBTK_END_DESCRIBE_BLACK_BOX(ImagePlanes);
  //=================================================================


}//namespace bbvtk


/*
namespace bbvtk
{
  typedef vtkImageData* vtkImageDataPointer;
}
*/
typedef vtkImageData* vtkImageDataPointer;	

namespace bbtk
{
  BBTK_DEFINE_HUMAN_READABLE_TYPE_NAME(vtkImageDataPointer, "vtkImageDataPointer");
}


#endif  //__bbtvtkImagePlanes_h__

#endif //_USE_VTK_

