/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbvtkPolyDataToActor.h,v $
  Language:  C++
  Date:      $Date: 2009/05/15 14:58:01 $
  Version:   $Revision: 1.12 $
=========================================================================*/                                                                  


/**
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
 */
/**
 * \file 
 * \brief Pattern for the definition of a new type of Node (header)
 */
/**
 * \class bbtk::NodePatern 
 * \brief Pattern for the definition of a new type of Node 
 */


#ifdef _USE_VTK_


#ifndef __vtkPolyDataToActor_h__
#define __vtkPolyDataToActor_h__

#include "vtkRenderer.h"
#include "vtkPolyData.h"
#include "vtkPolyDataMapper.h"
#include "vtkProp3D.h"
#include "vtkActor.h"
#include <vector>

#include "bbtkAtomicBlackBox.h"

namespace bbvtk
{
  
  class /*BBTK_EXPORT*/ PolyDataToActor
    : 
    public bbtk::AtomicBlackBox
  {
    bool              firsttime;
    vtkPolyDataMapper *polydatamapper;
    vtkActor          *vtkactor; 
    
    
    BBTK_BLACK_BOX_INTERFACE(PolyDataToActor,bbtk::AtomicBlackBox);
    
    BBTK_DECLARE_INPUT(In,vtkPolyData *);
    BBTK_DECLARE_INPUT(Opacity,double);
    BBTK_DECLARE_INPUT(Colour,std::vector<double>);
    BBTK_DECLARE_INPUT(Renderer,vtkRenderer *);
    BBTK_DECLARE_INPUT(Transform, vtkLinearTransform *);
    BBTK_DECLARE_INPUT(Representation, int);
    BBTK_DECLARE_INPUT(LineWidth, double);
    BBTK_DECLARE_INPUT(ScalarVisibility, bool);
    BBTK_DECLARE_OUTPUT(Out,vtkProp3D *);
    
    BBTK_PROCESS(DoProcess);
    void DoProcess();
    
  protected:
  };
  
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(PolyDataToActor,bbtk::AtomicBlackBox);
  BBTK_NAME("PolyDataToActor");
  BBTK_AUTHOR("eduardo.davila at creatis.insa-lyon.fr");
  BBTK_DESCRIPTION("takes a vtkPolyData object to insert into a 3D scene (e.g. a Viewer3D)");
  typedef std::vector<double> vectorcolour;
  BBTK_CATEGORY("3D object creator");
  BBTK_INPUT(PolyDataToActor,In,"Input image",vtkPolyData*,"");

  BBTK_INPUT(PolyDataToActor,Opacity,"Opacity",double,"");
  BBTK_INPUT(PolyDataToActor,Colour,"r g b",vectorcolour,"colour");
  BBTK_INPUT(PolyDataToActor,Renderer,"3D scene in which to insert the surface",vtkRenderer*,"");
  BBTK_INPUT(PolyDataToActor,Transform,"Linear Transform (4x4 homogeneous)",vtkLinearTransform*,"");
  BBTK_INPUT(PolyDataToActor,Representation,"0 points,1 wireframe, 2(default) surface",int,"");
  BBTK_INPUT(PolyDataToActor,LineWidth,"Width of the wireframe (1 default)",double,"");
  BBTK_INPUT(PolyDataToActor,ScalarVisibility,"Scalar Visibility (false default)",bool,"");
  BBTK_OUTPUT(PolyDataToActor,Out,"Extracted iso-surface",vtkProp3D *,"");
  
  BBTK_END_DESCRIBE_BLACK_BOX(PolyDataToActor);
  
}// EO namespace bbtk


#endif  //__PolyDataToActor_h__

#endif //_USE_VTK_
