/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#ifndef __bbvtkPolyDataWriterPlus_h_INCLUDED__
#define __bbvtkPolyDataWriterPlus_h_INCLUDED__
#include "bbvtk_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include <vtkDataSetSurfaceFilter.h>
#include <vtkUnstructuredGridReader.h>
#include <vtkSTLWriter.h>
#include <vtkMapper.h>
#include <vtkPolyDataMapper.h>
#include <vtkActor.h>
#include <vtkProp3D.h>
#include <vtkObject.h>
#include <vtkCommand.h>
#include <vtkPolyData.h>
#include <vtkXMLPolyDataWriter.h>
#include <vtkPolyDataWriter.h>
#include "names.h"

namespace bbvtk
{
#define OBS_PRE_WRITER_1 1201

#define OBS_POST_WRITER_1 1301

class bbvtk_EXPORT PolyDataWriterPlus
 :
   public bbtk::AtomicBlackBox,
   public vtkObject
{
  BBTK_BLACK_BOX_INTERFACE(PolyDataWriterPlus,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(InPrePersistObs1, vtkCommand*);
  BBTK_DECLARE_INPUT(InPostPersistObs1, vtkCommand*);
  BBTK_DECLARE_INPUT(InPath, std::string);
  BBTK_DECLARE_INPUT(In, vtkPolyData*);
  BBTK_DECLARE_INPUT(In2, vtkProp3D*);
  BBTK_DECLARE_INPUT(InFilePrefix, std::string);
  BBTK_PROCESS(Process);
  void Process();
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(PolyDataWriterPlus,bbtk::AtomicBlackBox);
BBTK_NAME("PolyDataWriterPlus");
BBTK_AUTHOR("_author_");
BBTK_DESCRIPTION("_description_");
BBTK_CATEGORY("__CATEGORY__");
BBTK_INPUT(PolyDataWriterPlus,InPrePersistObs1,"Who will be notified before persist", vtkCommand*,"");
BBTK_INPUT(PolyDataWriterPlus,InPostPersistObs1,"Who will be notified after persist", vtkCommand*,"");
BBTK_INPUT(PolyDataWriterPlus,InPath,"Path to the file to be created or rewrited",std::string,"");
BBTK_INPUT(PolyDataWriterPlus,In,"Information to be saved", vtkPolyData*,"");
BBTK_INPUT(PolyDataWriterPlus,In2,"Information to be saved", vtkProp3D*,"");
BBTK_END_DESCRIBE_BLACK_BOX(PolyDataWriterPlus);
}
// EO namespace bbvtk

#endif // __bbPersistenceVTKWriter_h_INCLUDED__

