/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


//=====
// Don't edit this file. This file is generated from xml description.. 
//===== 
#ifndef __bbvtkRescaleSlopeIntercept_h_INCLUDED__
#define __bbvtkRescaleSlopeIntercept_h_INCLUDED__
#include "bbvtk_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include "vtkImageData.h"
#include <vtkImageShiftScale.h>
#include <vtkImageChangeInformation.h>



namespace bbvtk
{

class bbvtk_EXPORT RescaleSlopeIntercept
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(RescaleSlopeIntercept,bbtk::AtomicBlackBox);
//===== 
// Don't edit this file. This file is generated from xml description.. 
//===== 
  BBTK_DECLARE_INPUT(In,vtkImageData*);
  BBTK_DECLARE_INPUT(Type,int);
  BBTK_DECLARE_INPUT(A,double);
  BBTK_DECLARE_INPUT(B,double);
  BBTK_DECLARE_INPUT(OutputFormat,std::string);
  BBTK_DECLARE_OUTPUT(Out,vtkImageData*);
  BBTK_PROCESS(Process);
  void Process();
	
	int							outputformat;
	vtkImageShiftScale			*filter1;
	vtkImageShiftScale			*filter2;
	vtkImageChangeInformation	*mchange;

//===== 
// Don't edit this file. This file is generated from xml description.. 
//===== 
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(RescaleSlopeIntercept,bbtk::AtomicBlackBox);
BBTK_NAME("RescaleSlopeIntercept");
BBTK_AUTHOR("eduardo.davila at creatis.insa-lyon.fr");
BBTK_DESCRIPTION("Rescale Slope Intercept  (see Type input descriptio)");
BBTK_CATEGORY("filter");
BBTK_INPUT(RescaleSlopeIntercept,In,"Image input",vtkImageData*,"");
BBTK_INPUT(RescaleSlopeIntercept,Type,"type of operation: 0 (default) SlopeIntercept np=p*A+B, 1 Invert, 2 Redimension A=newMin B=newMax, 3 InvertRedimension A=newMin B=newMax",int,"");
BBTK_INPUT(RescaleSlopeIntercept,A,"(1 default) see Type description",double,"");
BBTK_INPUT(RescaleSlopeIntercept,B,"(0 default) see Type description",double,"");
BBTK_INPUT(RescaleSlopeIntercept,OutputFormat,"Image output format:  SAME (default), VTK_BIT, VTK_CHAR, VTK_SIGNED_CHAR, VTK_UNSIGNED_CHAR, VTK_SHORT, VTK_UNSIGNED_SHORT, VTK_INT, VTK_UNSIGNED_INT, VTK_LONG, VTK_UNSIGNED_LONG, VTK_FLOAT, VTK_DOUBLE",std::string,"");
BBTK_OUTPUT(RescaleSlopeIntercept,Out,"Image output",vtkImageData*,"");
BBTK_END_DESCRIBE_BLACK_BOX(RescaleSlopeIntercept);
//===== 
// Don't edit this file. This file is generated from xml description.. 
//===== 
}
// EO namespace bbvtk

#endif // __bbvtkRescaleSlopeIntercept_h_INCLUDED__

