/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbvtkSegmentationConnectivity.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:58 $
  Version:   $Revision: 1.7 $
=========================================================================*/

/**
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
 */
/**
 * \file 
 * \brief Pattern for the definition of a new type of Node (header)
 */
/**
 * \class bbtk::NodePatern 
 * \brief Pattern for the definition of a new type of Node 
 */


#ifdef _USE_VTK_

#ifndef __bbvtkSegmentationConnectivity_h_INCLUDED__
#define __bbvtkSegmentationConnectivity_h_INCLUDED__

#include "bbtkAtomicBlackBox.h"
#include <vtkImageData.h>
#include <vtkImageCast.h>
#include <vtkImageThreshold.h>
#include <vtkImageSeedConnectivity.h>

namespace bbvtk
{

  class SegmentationConnectivity
    : 
    public bbtk::AtomicBlackBox
  {
    BBTK_BLACK_BOX_INTERFACE(SegmentationConnectivity,bbtk::AtomicBlackBox);
    BBTK_DECLARE_INPUT(In,vtkImageData *);
    BBTK_DECLARE_INPUT(PositionXYZ,std::vector<int>);
    BBTK_DECLARE_INPUT(ThresholdMinMax,std::vector<int>);
    BBTK_DECLARE_OUTPUT(Out,vtkImageData *);
    BBTK_PROCESS(DoProcess);
    void DoProcess();

  protected:

  private:
	vtkImageCast             *cast2;
	vtkImageCast             *cast4; // binary segmentation result
	vtkImageThreshold        *thresh2;
	vtkImageSeedConnectivity *connect2;

  };

  BBTK_BEGIN_DESCRIBE_BLACK_BOX(SegmentationConnectivity,bbtk::AtomicBlackBox);
  BBTK_NAME("SegmentationConnectivity");
  BBTK_AUTHOR("eduardo.davila [at] creatis.insa-lyon.fr");
  BBTK_DESCRIPTION("Segmentation with min max threshold and connectivity");
  BBTK_INPUT(SegmentationConnectivity,In,"Input image",vtkImageData *,"");
  BBTK_INPUT(SegmentationConnectivity,PositionXYZ,"vector with the Position [x y z]" , std::vector<int>,"");
  BBTK_INPUT(SegmentationConnectivity,ThresholdMinMax,"vector with the Threshold [min max]" , std::vector<int>,"");
  BBTK_OUTPUT(SegmentationConnectivity,Out,"Result image",vtkImageData *,"");
  BBTK_END_DESCRIBE_BLACK_BOX(SegmentationConnectivity);

} // EO namespace bbvtk

#endif //  __bbvtkSegmentationConnectivity_h_INCLUDED__

#endif //_USE_VTK_
