/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


//=====
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
#ifndef __bbvtkText3D_h_INCLUDED__
#define __bbvtkText3D_h_INCLUDED__
#include "bbvtk_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include "vtkProp3D.h"
#include "vtkRenderer.h"
#include "vtkLinearTransform.h"
#include "vtkTextActor3D.h"
#include "vtkTextProperty.h"


namespace bbvtk
{

class bbvtk_EXPORT Text3D
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(Text3D,bbtk::AtomicBlackBox);
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
	BBTK_DECLARE_INPUT(In,std::string);
	BBTK_DECLARE_INPUT(X,int);
	BBTK_DECLARE_INPUT(Y,int);
	BBTK_DECLARE_INPUT(Z,int);
	BBTK_DECLARE_INPUT(Opacity,double);
	BBTK_DECLARE_INPUT(Colour,std::vector<double>);
	BBTK_DECLARE_INPUT(Renderer,vtkRenderer*);
	BBTK_DECLARE_INPUT(Transform,vtkLinearTransform*);
	
	BBTK_DECLARE_OUTPUT(Out,vtkProp3D*);
	BBTK_PROCESS(Process);
	void Process();
	
	vtkTextActor3D *_textActor;
	vtkTextProperty *_textProp;
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(Text3D,bbtk::AtomicBlackBox);
BBTK_NAME("Text3D");
BBTK_AUTHOR("Info-Deb");
BBTK_DESCRIPTION("Text in 3D vtkRender");
BBTK_CATEGORY("");
	
	BBTK_INPUT(Text3D,In,"Input Text",std::string,"");
	BBTK_INPUT(Text3D,X,"position X",int,"");
	BBTK_INPUT(Text3D,Y,"position Y",int,"");
	BBTK_INPUT(Text3D,Z,"position Z",int,"");
	BBTK_INPUT(Text3D,Opacity,"0..1   (default 1)",double,"");
	BBTK_INPUT(Text3D,Colour,"Colour vector RGB  < 0..1 , 0..1 , 0..1 >",std::vector<double>,"");
	BBTK_INPUT(Text3D,Renderer,"vtk Renderer",vtkRenderer*,"");
	BBTK_INPUT(Text3D,Transform,"",vtkLinearTransform*,"");

	BBTK_OUTPUT(Text3D,Out,"vtk Actor",vtkProp3D*,"");

BBTK_END_DESCRIBE_BLACK_BOX(Text3D);
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
}
// EO namespace bbvtk

#endif // __bbvtkText3D_h_INCLUDED__

