/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbwxLayoutLine.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:52:14 $
  Version:   $Revision: 1.11 $
=========================================================================*/


/**
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
 */
/**
 * \file 
 * \brief Pattern for the definition of a new type of Node (header)
 */
/**
 * \class bbtk::NodePatern 
 * \brief Pattern for the definition of a new type of Node 
 */


#ifdef USE_WXWIDGETS


#ifndef __bbWxLayoutLine_h__
#define __bbWxLayoutLine_h__

#include "bbtkWxBlackBox.h"
#include "bbwx_EXPORT.h"


namespace bbwx
{
  

  
  //===========================================================
  class bbwx_EXPORT LayoutLine : public bbtk::WxBlackBox
  {
    
    BBTK_BLACK_BOX_INTERFACE(LayoutLine,bbtk::WxBlackBox);
    BBTK_DECLARE_INPUT(Widget1,wxWindow*);
    BBTK_DECLARE_INPUT(Widget2,wxWindow*);
    BBTK_DECLARE_INPUT(Widget3,wxWindow*);
    BBTK_DECLARE_INPUT(Widget4,wxWindow*);
    BBTK_DECLARE_INPUT(Widget5,wxWindow*);
    BBTK_DECLARE_INPUT(Widget6,wxWindow*);
    BBTK_DECLARE_INPUT(Widget7,wxWindow*);
    BBTK_DECLARE_INPUT(Widget8,wxWindow*);
    BBTK_DECLARE_INPUT(Widget9,wxWindow*);
    BBTK_DECLARE_INPUT(Orientation,std::string);
    BBTK_PROCESS(Process);
    BBTK_CREATE_WIDGET(CreateWidget);
    BBTK_ON_SHOW_WIDGET(OnShowWidget);
 
    void Process();
    void CreateWidget(wxWindow*);
    void OnShowWidget();
    
  protected:
	void TryInsertWindow(wxWindow *parent, wxWindow *w,wxBoxSizer *sizer);

  };
  //===========================================================
  
 
  //=================================================================
  // BlackBox description
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(LayoutLine,bbtk::WxBlackBox);
  BBTK_NAME("LayoutLine");
  BBTK_AUTHOR("eduardo.davila@creatis.insa-lyon.fr");
  BBTK_DESCRIPTION("LayoutLine widget (wxBoxSizer)");
  // Already inserted for any WxBlackBox  BBTK_CATEGORY("widget");  
  BBTK_INPUT(LayoutLine,Widget1,"widget 1",wxWindow*,"");
  BBTK_INPUT(LayoutLine,Widget2,"widget 2",wxWindow*,"");
  BBTK_INPUT(LayoutLine,Widget3,"widget 3",wxWindow*,"");
  BBTK_INPUT(LayoutLine,Widget4,"widget 4",wxWindow*,"");
  BBTK_INPUT(LayoutLine,Widget5,"widget 5",wxWindow*,"");
  BBTK_INPUT(LayoutLine,Widget6,"widget 6",wxWindow*,"");
  BBTK_INPUT(LayoutLine,Widget7,"widget 7",wxWindow*,"");
  BBTK_INPUT(LayoutLine,Widget8,"widget 8",wxWindow*,"");
  BBTK_INPUT(LayoutLine,Widget9,"widget 9",wxWindow*,"");
  BBTK_INPUT(LayoutLine,Orientation,"Orientation (default V), 0=H=HORIZONTAL , 1=V=VERTICAL",std::string,"");
  BBTK_END_DESCRIBE_BLACK_BOX(LayoutLine);
  //=================================================================
  
  
  
}



//namespace bbtk
#endif  //__bbtkWxLayoutLine_h__

#endif //USE_WXWIDGETS
