/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbwxRadioButton.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:52:14 $
  Version:   $Revision: 1.9 $
=========================================================================*/

/**
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
 */
/**
 * \file 
 * \brief Pattern for the definition of a new type of Node (header)
 */
/**
 * \class bbtk::NodePatern 
 * \brief Pattern for the definition of a new type of Node 
 */


#ifdef _USE_WXWIDGETS_

// Prevents multiple inclusions : use symbols of the form
// __FILENAME_INCLUDED__ 
// where FILENAME must be replaced by the actual file name
#ifndef __bbWxRadioButton_h__
#define __bbWxRadioButton_h__

#include "bbtkWxBlackBox.h"
#include "bbwx_EXPORT.h"


// Namespace of the package "wx" is "bbwx" 
// Namespace associated to packages should be of the form :
// bbPACKAGENAME
namespace bbwx
{
  
  
  class bbwx_EXPORT RadioButton : public bbtk::WxBlackBox
  {

    BBTK_BLACK_BOX_INTERFACE(RadioButton,bbtk::WxBlackBox);
    BBTK_DECLARE_INPUT(In,int);
    BBTK_DECLARE_INPUT(In0,std::string);
    BBTK_DECLARE_INPUT(In1,std::string);
    BBTK_DECLARE_INPUT(In2,std::string);
    BBTK_DECLARE_INPUT(In3,std::string);
    BBTK_DECLARE_INPUT(In4,std::string);
    BBTK_DECLARE_INPUT(In5,std::string);
    BBTK_DECLARE_INPUT(In6,std::string);
    BBTK_DECLARE_INPUT(In7,std::string);
    BBTK_DECLARE_INPUT(In8,std::string);
    BBTK_DECLARE_INPUT(In9,std::string);
    BBTK_DECLARE_INPUT(Title,std::string);
    BBTK_DECLARE_OUTPUT(Out,int);
    BBTK_CREATE_WIDGET(CreateWidget);
    BBTK_PROCESS(Process);
    void Process();
    void CreateWidget(wxWindow*);

  protected:

  };
 
  //=================================================================
  // UserBlackBox description
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(RadioButton,bbtk::WxBlackBox);
  BBTK_NAME("RadioButton");
  BBTK_AUTHOR("eduardo.davila@creatis.insa-lyon.fr");
  BBTK_DESCRIPTION("RadioButton group widget 0-9 entries");
  BBTK_INPUT(RadioButton,In,"Set initial item",int,"");

  BBTK_INPUT(RadioButton,In0,"option 0",std::string,"");
  BBTK_INPUT(RadioButton,In1,"option 1",std::string,"");
  BBTK_INPUT(RadioButton,In2,"option 2",std::string,"");
  BBTK_INPUT(RadioButton,In3,"option 3",std::string,"");
  BBTK_INPUT(RadioButton,In4,"option 4",std::string,"");
  BBTK_INPUT(RadioButton,In5,"option 5",std::string,"");
  BBTK_INPUT(RadioButton,In6,"option 6",std::string,"");
  BBTK_INPUT(RadioButton,In7,"option 7",std::string,"");
  BBTK_INPUT(RadioButton,In8,"option 8",std::string,"");
  BBTK_INPUT(RadioButton,In9,"option 9",std::string,"");

  BBTK_INPUT(RadioButton,Title,"Title of the widget (default '') ",
	     std::string,"");

  BBTK_OUTPUT(RadioButton,Out,"Item selected",int,"");
  BBTK_END_DESCRIBE_BLACK_BOX(RadioButton);
  //=================================================================

}

//namespace bbtk
#endif  //__bbWxRadioButton_h__

#endif //_USE_WXWIDGETS_
