/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __COMMANDS_REGISTER_STRUCTURE__
#define __COMMANDS_REGISTER_STRUCTURE__

//------------------------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------------------------

#include <vector>
#include <iostream>
#include "CommandObject.h"

class CommandsRegisterStructure{

//------------------------------------------------------------------------------------------------------------
// Constructors & Destructors
//------------------------------------------------------------------------------------------------------------
public:

	/*
	* Creates the CommandsRegisterStructure
	*/
	CommandsRegisterStructure();

	/*
	* Destroys the CommandsRegisterStructure
	*/
	~CommandsRegisterStructure();

//------------------------------------------------------------------------------------------------------------
// Methods
//------------------------------------------------------------------------------------------------------------

	/**
	* Registers a command in the vector with no verification, is should be well constructed
	* @param theCommand The command to register
	*/
	void registerCommand(CommandObject * theCommand);

	/*
	* Gets the -ACTUAL- command text 
	* @return
	*/
	//std::string getActualCommandText();

	/*
	* Gets the -LAST- command text 
	* @return
	*/
	//std::string getLastCommandText();

	/*
	* Deletes all the registered actions and reinitialize the -ACTUAL- and  -LAST- iterators
	*/
	void clearActions();

	/*
	* Moves to the the previous position the -ACTUAL- iterator
	* @return Indicates true if it was done
	*/
	bool moveBack_Actual();

	/*
	* Moves to the the next position the -ACTUAL- iterator
	* @return Indicates true if it was done
	*/
	bool moveForward_Actual();

	/*
	* Moves to the the previous position the -LAST- iterator
	* @return Indicates true if it was done
	*/
	bool moveBack_Last();

	/*
	* Moves to the the next position the -LAST- iterator
	* @return Indicates true if it was done
	*/
	bool moveForward_Last();

	/*
	* Indicates if the -LAST- iterator has a next action or not
	* @return Returns true if it has
	*/
	bool hasLastNext();

	/*
	* Indicates if the -ACTUAL- iterator has a next action or not
	* @return Returns true if it has
	*/
	bool hasActualNext();

	/*
	* Indicates if the -LAST- iterator has a previous action or not
	* @return Returns true if it has
	*/
	bool hasLastPrevious();

	/*
	* Indicates if the -ACTUAL- iterator has a previous action or not
	* @return Returns true if it has
	*/
	bool hasActualPrevious();

	/*
	* Puts to point the -ACTUAL- iterator up to the -LAST-  iterator.
	*/
	void levelActualToLast();

	/*
	* Puts to point the -LAST- iterator up to the -ACTUAL- iterator and erases automatically the actions after the 
	* referenced last and the end of the registered actions if nothing is given by parameter.	
	*/
	void levelLastToActual(bool clearingAfterLast = true);

	/*
	* Clear all the elements in the vector bettween the -LAST- iterator and the end of the vector
	*/
	void clearAll_afterLast();

	/*
	* Clear all the elements in the vector bettween the -ACTUAL- iterator and the start of the vector 	
	*/
	void clearAll_beforeActual();

	/**
	* Indicates if there are actions in the vector of not
	* @return Returns true is there are not registered actions	
	*/
	bool isEmpty();

	/**
	* Indicates the quantity of actions that are registered
	* @return Returns the total amount of registered actions in the vector
	*/
	int getCommandsCount();

	/*
	* Gets the -ACTUAL-  iterator information data pointer
	* @return The pointer to the referenced object by the -ACTUAL- iterator
	*/
	CommandObject * getActual_Pointer();

	/*
	* Gets the -LAST-  iterator information data pointer
	* @return The pointer to the referenced object by the -LAST- iterator
	*/
	CommandObject * getLast_Pointer();

	/*
	* Gets the command at the given position 
	* @return The pointer to the referenced object by the position
	*/
	CommandObject * getCommandAt(int position);

	/*
	* Gets the index of the actualAction in the vector
	* @return actualIndexToExec Is the corresponding index
	*/
	int getActualIndex();

	/*
	* Gets the index of the lasAction in the vector
	* @return lasAction Is the corresponding index
	*/
	int getLasIndex();

	/*
	* Sets the index of the actualAction in the vector
	* @param newActualIndex Is the corresponding index
	*/
	void setActualIndex(int newActualIndex);

	/*
	* Sets the index of the lasAction in the vector
	* @param newLasIndex Is the corresponding index
	*/
	void setLasIndex(int newLasIndex);

	/*
	* Gets the registered commands vector size
	* @return Returns the vector size
	*/
	int getRegistereCommandsCount();

	/*
	* Gets the total registered commands 
	* @return Returns the total of commands
	*/
	int getTotalCommandsCount();


	

//------------------------------------------------------------------------------------------------------------
// Constants
//------------------------------------------------------------------------------------------------------------

private: 	
//------------------------------------------------------------------------------------------------------------
// Attributes
//------------------------------------------------------------------------------------------------------------
	
	/*
	* Represents the actions successfully registered 
	*/
	std::vector<CommandObject*> registeredActions;
	
	/*
	* Represents the index to the actual action to execute at the registered actions vector
	*/
	//std::vector <CommandObject*>::iterator actualAction;
	int actualIndexToExec;
	
	/*
	* Represents the index to the last action executed at the registered actions vector
	*/
	//std::vector <CommandObject*>::iterator lastAction;   
	int lastAction;   

};
#endif
