/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __INSTANT_MEMBERS_NAME_LIST__
#define __INSTANT_MEMBERS_NAME_LIST__


//------------------------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------------------------
#include <vector>
#include <iostream>
#include <string>

#include "NameWrapper.h"


class InstantMembersNameList{

//------------------------------------------------------------------------------------------------------------
// Constructors & Destructors
//------------------------------------------------------------------------------------------------------------
public:

	/*
	* Create the InstantMembersNameList with empty data pointers
	*/
	InstantMembersNameList();

	/*
	* Destroys the InstantMembersNameList
	*/
	~InstantMembersNameList();

//------------------------------------------------------------------------------------------------------------
// Methods
//------------------------------------------------------------------------------------------------------------

	/*
	* Sets the actual outline names pair
	* @param thekeyName The key name asigned to the actual outline	
	* @param theRealName The real name asigned to the actual outline
	*/
	void setActualOutline(std::string thekeyName, std::string theRealName );

	/*
	* Sets the actual axes names pair
	* @param thekeyName The key name asigned to the actual outline	
	* @param theRealName The real name asigned to the actual outline
	*/
	void addOutlineName(std::string thekeyName, std::string theRealName);
	
	/*
	* Sets the actual axes names pair
	* @param thekeyName The key name asigned to the actual axe	
	* @param theRealName The real name asigned to the actual axe
	*/
	void setActualAxeWrap(std::string thekeyName, std::string theRealName);

	/*
	* Gets the actual axes key name
	* @return actualAxeKeyName The key name asigned to the actual axe
	*/
	std::string getActualAxeKeyName();

	/*
	* Gets the actual axes key name
	* @return actualSourceImageKeyName The key name asigned to the actual axe
	*/
	std::string getActualSourceImageKeyName();

	/*
	* Gets the actual axes key name
	* @return actualSectionImageKeyName The key name asigned to the actual axe
	*/
	std::string getActualSectionImageKeyName();

	/*
	* Gets the vector of the key names of currect instant outlines
	* @return vectorPairedNames The vector with the pair of outline names wrapping
	*/
	std::vector<NameWrapper *> getOutlinesNamesVector();


	/*
	* Sets the actualSourceImage names pair
	* @param thekeyName The key name asigned to the actual outline	
	* @param theRealName The real name asigned to the actual outline
	*/
	void setActualSourceImageNamesWrapp(std::string thekeyName, std::string theRealName);

	/*
	* Sets the actualSectionImage names pair
	* @param thekeyName The key name asigned to the actual outline	
	* @param theRealName The real name asigned to the actual outline
	*/
	void setActualSectionImageNamesWrapp(std::string thekeyName, std::string theRealName);
	
	/*
	* Cleans the vector and the information of the instant members wrapping
	*/
	void clean();

//------------------------------------------------------------------------------------------------------------
// Constants
//------------------------------------------------------------------------------------------------------------

private: 	
//------------------------------------------------------------------------------------------------------------
// Attributes
//------------------------------------------------------------------------------------------------------------

	std::vector<NameWrapper *> outlinesNamesVector;

	std::vector<std::string> axesNamesVector;

	NameWrapper * actualAxeNamesWrapp;

	NameWrapper * actualSourceImageNamesWrapp;

	NameWrapper * actualSectionImageNamesWrapp;

	NameWrapper * actualOutlineNamesWrapp;
};
#endif
