/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __OsirixParser__
#define __OsirixParser__


#if defined(_WIN32)
#include "Windows.h"
  #ifdef kernelParserOsirix_BUILD_SHARED
    #define kernelParserOsirix_EXPORT __declspec( dllexport )
  #else
    #define kernelParserOsirix_EXPORT __declspec( dllimport )
  #endif
  #define kernelParserOsirix_CDECL __cdecl
#else
  #define kernelParserOsirix_EXPORT
  #define kernelParserOsirix_CDECL
#endif // defined(_WIN32)

//------------------------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------------------------

#include <iostream>
#include <vector>
#include <map>
#include <xercesc/parsers/XercesDOMParser.hpp>
#include <xercesc/dom/DOM.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>
#include <xercesc/dom/DOMLocator.hpp>
#include <xercesc/sax/HandlerBase.hpp>
#include <xercesc/util/XMLString.hpp>
#include <xercesc/util/PlatformUtils.hpp>


using namespace std;
using namespace xercesc;



class OsirixParser{

//------------------------------------------------------------------------------------------------------------
// Constructors & Destructors
//------------------------------------------------------------------------------------------------------------
public:

	/**
	** Constructor for the parser, with the information of the pixel spacing and image dimensions
	**/
	OsirixParser(std::string xsdfile = "", double* spacing = NULL, int* extent = NULL);
	/**
	** Desctructor by defect
	**/
	~OsirixParser();	

	int ParseFile(const char* xmlfile);
	
	
	std::string getErrorLine();

	std::string getContoursFileName();

	// Return ROI as lists of points
	const std::map<int, vector< vector<double> > >& getContoursMapMM() {
	  return contoursmapMM;
	}
	const std::map<int, vector< vector<double> > >& getContoursMapPX() {
	  return contoursmapPX;
	}

	// Return ROI names
	const std::map<int, std::string>& getContoursNameMM() {
	  return contoursnameMM;
	}
	const std::map<int, std::string>& getContoursNamePX() {
	  return contoursnamePX;
	}

private:

	std::string schema;

	std::string errorline;	

	int _imageindex;
	std::string _roiname;

	const char* OSIRIX_DICT;
	const char* OSIRIX_KEY;
	const char* OSIRIX_IMAGES;
	const char* OSIRIX_ARRAY;
	const char* OSIRIX_IMAGEINDEX;
	const char* OSIRIX_INTEGER;
	const char* OSIRIX_NUMBEROFROIS;
	const char* OSIRIX_ROIS;
	const char* OSIRIX_POINT_MM;
	const char* OSIRIX_POINT_PX;
	const char* OSIRIX_STRING;		
	const char* OSIRIX_NAME;

	const char* CREACONTOUR;
	const char* CREACONTOUR_VERSION;
	const char* CREACONTOUR_IMAGEDIMENSIONS;
	const char* CREACONTOUR_IMAGESPACING;
	const char* CREACONTOUR_NUMBEROFCONTOURS;

	const char* CREACONTOUR_INSTANT;
	const char* CREACONTOUR_TYPEMODEL;
	const char* CREACONTOUR_NUMBEROFCONTROLPOINTS;
	const char* CREACONTOUR_TYPEVIEW;	
	
	const char* CREACONTOUR_NUMBEROFCONTOURSSTATIC;

	std::string TEMPIMPORTOSIRIXFILE;

	double _spacing[3];
	int _extent[6];

	typedef vector< vector<double> > vectorXYZ;
	std::map<int, vectorXYZ> contoursmapMM;	
	std::map<int, vectorXYZ> contoursmapPX;

	std::map<int, std::string> contoursnameMM;
	std::map<int, std::string> contoursnamePX;

	void saveCreaContoursFormat();

	void writeHeader(FILE* pFile);
	void writeContours(FILE* pFile);
	void writeContoursStatic(FILE* pFile);

	void setErrorLine(DOMNodeList* list);	

	void getUserData(DOMElement* element);	

	void getData(DOMNodeList* list, std::vector<std::string>& vect, std::string tagname);

	DOMNode* getLastNode(DOMNodeList* list);

	void parseOSIRIX_DICT(DOMNodeList* list);
	void parseOSIRIX_POINT_MM(DOMNodeList* list);
	void parseOSIRIX_POINT_PX(DOMNodeList* list);

	

	
};

class OsirixParserErrorHandler : public ErrorHandler{

//------------------------------------------------------------------------------------------------------------
// Constructors & Destructors
//------------------------------------------------------------------------------------------------------------
public:

	/**
	** Default Constructor
	**/
	OsirixParserErrorHandler();
	/**
	** Desctructor by defect
	**/
	~OsirixParserErrorHandler();	

	virtual void 	warning (const SAXParseException &exc); 	

	virtual void 	error (const SAXParseException &exc); 		

	virtual void 	fatalError (const SAXParseException &exc); 		

	virtual void 	resetErrors ();

	std::string getErrorMsg();

private:

	
	std::string errormsg;

	

	
	
};
#endif
