/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __OUTLINE_MODEL_BUILDER__
#define __OUTLINE_MODEL_BUILDER__


//------------------------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------------------------
#include <iostream>
#include <vector>
#include <string>


#include "ReaderEnvironment.h"
#include "SomeEnvironment.h"
#include "ContourThing.h"
#include "AxeThing.h"
#include "ImageSourceThing.h"
#include "ImageSectionThing.h"



class OutlineModelBuilder{

//------------------------------------------------------------------------------------------------------------
// Constructors & Destructors
//------------------------------------------------------------------------------------------------------------
public:

	/**
	* Creates an OutlineModelBuilder
	* @ param filesNames Paired set of files with the names of the files to read ConceptsFileName, ImageSourcesFile, ImageSectionsFile, AxeThingsFile, ContoursFile
	* @ param sources Paired set of sourceKeyName-ImageSourceThing
	* @ param sections Paired set of sectionKeyName-ImageSectionThing
	* @ param axes Paired set of axeKeyName-AxeThing
	* @ param outlines Paired set of contoKeyName-ContourThing
	*/
	OutlineModelBuilder(std::string conceptsFile, std::string datadir = "data" );//std::map<std::string, std::string> filesNames, std::map<std::string, ImageSourceThing *> * sources, std::map<std::string, ImageSectionThing *>* sections, std::map<std::string, AxeThing *>* axes, std::map<std::string, ContourThing *>* outlines);

	/**
	* Destroys an AxeThing
	*/
	~OutlineModelBuilder();
//------------------------------------------------------------------------------------------------------------
// Methods
//------------------------------------------------------------------------------------------------------------

	/**
	* Gets the ImageSourceThing environment
	*@param  ImSourceEnv 
	*/
    SomeEnvironment<ImageSourceThing *> * getImSourceEnv();
	/**
	* Gets the ImageSectionThing environment
	*@param  imSectionEnv 
	*/
	SomeEnvironment<ImageSectionThing *> * getImSectionEnv();
	/**
	* Gets the AxeThing environment
	*@param  AxesEnv
	*/
	SomeEnvironment<AxeThing *> * getAxesEnv();
	/**
	* Gets the ContourThing environment
	* @param  ContourEnv 
	*/
	SomeEnvironment<ContourThing *> * getContourEnv();
	
	/**
	* Builds the ImageSourceThing * environment
	* @param sourcesFile File path with the object key names and specific instants for each one
	* @param sources The sources to include in the enivorment
	*/
	void buildImageSource_Envornment( std::string sourcesFile, std::map<std::string, ImageSourceThing *> * sources );

	/**
	* Builds the ImageSectionThing * environment
	* @param sectionsFile File path with the object key names and specific instants for each one
	* @param sections The sections to include in the enivorment
	*/
	void buildImageSection_Envornment( std::string sectionsFile, std::map<std::string, ImageSectionThing *>* sections );

	/**
	* Builds the AxeThing * environment
	* @param axesFile File path with the object key names and specific instants for each one
	* @param axes The axes to include in the enivorment
	*/
	void buildAxe_Envornment( std::string axesFile, std::map<std::string, AxeThing *>* axes );

	/**
	* Builds the CountourThing * environment
	* @param outlinesFile File path with the object key names and specific instants for each one
	* @param outlines The outlines to include in the enivorment
	*/
	void buildCountour_Envornment( std::string outlinesFile, std::map<std::string, ContourThing *>* outlines );

private:
//------------------------------------------------------------------------------------------------------------
// Attributes
//------------------------------------------------------------------------------------------------------------
	
	/**
	* Represents the environment builder based of reading files of axes
	*/
	ReaderEnvironment<AxeThing *> *axesEnv_Reader;

	/**
	*  Represents the environment builder based of reading files of section images 
	*/
	ReaderEnvironment<ImageSectionThing *> *imagesSectionEnv_Reader;

	/**
	* Represents the environment builder based of reading files of source images (Generally a complete volume data per image) 
	*/
	ReaderEnvironment<ImageSourceThing *>  *imageSourceEnv_Reader;

	/**
	* Represents the environment builder based of reading files of outlines (outlines)
	*/
	ReaderEnvironment<ContourThing *> * outlinesEnv_Reader;

	/*
	*
	*/
	std::string conceptsFile;

	std::string imagesSectionEnvOtherConceptsFN;

	std::string outlinesEnvOtherConceptsFN;

	std::string axesEnvOtherConceptsFN;
	

};
#endif

