/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __wxConceptControl_h_INCLUDED_H__
#define __wxConceptControl_h_INCLUDED_H__


// -----------------------------------------------------------------------------------------------------------
// WX headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// -----------------------------------------------------------------------------------------------------------

#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif


//------------------------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------------------------
#include <iostream>
#include <vector>

//------------------------------------------------------------------------------------------------------------
// Events declaration
//------------------------------------------------------------------------------------------------------------
BEGIN_DECLARE_EVENT_TYPES()
	DECLARE_EVENT_TYPE( wxEVT_CONCEPT_RELEASE, -1 )	
END_DECLARE_EVENT_TYPES()

/** file wxConceptControl.h */

//------------------------------------------------------------------------------------------------------------
// Class definition
//------------------------------------------------------------------------------------------------------------

class wxConceptControl : public wxPanel {

	public:

	//------------------------------------------------------------------------------------------------------------
	// Constructors & Destructors
	//------------------------------------------------------------------------------------------------------------
	
	wxConceptControl(wxWindow *parent, bool orientation, int minV, int maxV, int actualV, std::string &aConceptName, std::string elementsDef = "");

	~wxConceptControl();

	//------------------------------------------------------------------------------------------------------------
	// Methods for capturing events
	//------------------------------------------------------------------------------------------------------------
	
	void onUpdateUICheckBox(wxCommandEvent& event);

	void OnCheckOrRadioBox(wxCommandEvent& event);

	void onSliderTrack(wxScrollEvent& event);
	
	void onSliderRelease(wxScrollEvent& event);
	
	//------------------------------------------------------------------------------------------------------------
	//  Methods for sending events
	//------------------------------------------------------------------------------------------------------------
	void sendEnvent( WXTYPE theEventType );
	//------------------------------------------------------------------------------------------------------------
	//  Attributes getters and setters
	//------------------------------------------------------------------------------------------------------------

	std::string getName();

	int getMinShowedValue();

	int getMaxShowedValue();

	void setMinValue(int theMin);

	int getMinValue();

	void setMaxValue(int theMax);

	int getMaxValue();

	void setActualValue(int theActual);

	int getActualValue();

	void setShowLables(bool ifShowCondition);

	//------------------------------------------------------------------------------------------------------------
	//  Other functional methods
	//------------------------------------------------------------------------------------------------------------

	void clearCheckAt( int position );

	bool getIfChecked( int position );

	void setRange(int minShow, int maxShow);

	void reset();

	int getNumCheckBox();

private:
	//------------------------------------------------------------------------------------------------------------
	//  Private methods
	//------------------------------------------------------------------------------------------------------------

	//------------------------------------------------------------------------------------------------------------
	// Creational and initialization methods
	//------------------------------------------------------------------------------------------------------------
	
	void createElements( wxSizer *sizer, std::string elementsDef );
	
	wxCheckBox * createCheckBoxAndAddToSizer(wxSizer *sizer, std::string label, wxWindowID id, int groupID);

	
	//------------------------------------------------------------------------------------------------------------
	// Attributtes
	//------------------------------------------------------------------------------------------------------------

	wxSlider * conceptSlider;

	//std::string conceptName;

	wxStaticText		* conceptName;

	std::vector<wxTextCtrl *> textBoxes;

	std::vector<wxCheckBox *> checkBoxes;

	wxCheckBox * lastUpdate;

	int minValue;

	int maxValue;

	bool showLabels;

	int _numCheckBox;


	//DECLARE_CLASS(wxConceptControl)


	// any class wishing to process wxWindows events must use this macro
//	DECLARE_EVENT_TABLE()

};
#endif // __wxConceptControl__

