/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __wxContourMainFrame_h_INCLUDED_H__
#define __wxContourMainFrame_h_INCLUDED_H__


// -----------------------------------------------------------------------------------------------------------
// WX headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// -----------------------------------------------------------------------------------------------------------

#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif


//------------------------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------------------------
#include "wx/aui/aui.h"

#include "interfMainPanel.h"
#include "KernelManagerContour.h"

//#include "wxVtkBaseView_SceneManager.h"
#include "wxInstantChooserPanel.h"
#include "wxContourViewPanel.h"

//#include "ContourWorkspace.h"
#include "ContourExtractData.h"
#include "PerformingOperation.h"

#include "manualLineControler.h"
#include "manualContourModelLine.h"
#include "manualViewLine.h"

#include "ThresholdImageView.h"
#include "ThresholdImageViewPanel.h"
#include "ColorLayerImageView.h"
#include "ColorLayerImageViewPanel.h"


//ITK
#include "itkImage.h"
#include "itkGeodesicActiveContourLevelSetImageFilter.h"

#include "itkCurvatureAnisotropicDiffusionImageFilter.h"
#include "itkGradientMagnitudeRecursiveGaussianImageFilter.h"
#include "itkSigmoidImageFilter.h"
#include "itkFastMarchingImageFilter.h"
#include "itkRescaleIntensityImageFilter.h"
#include "itkBinaryThresholdImageFilter.h"
#include "itkZeroCrossingImageFilter.h"
#include "itkCastImageFilter.h"

//EED10JUIN2011  #include "itkImageFileWriter.h"

#include "itkImageToVTKImageFilter.h"
#include "itkVTKImageToImageFilter.h"

//VTK
#include <vtkImageSeedConnectivity.h>
#include <vtkImageMarchingCubes.h>
#include "vtkContourFilter.h"
#include "vtkMarchingContourFilter.h"
#include "vtkPolyDataConnectivityFilter.h"
#include "vtkCleanPolyData.h"
#include "vtkImageReslice.h"
#include "vtkMetaImageWriter.h"
#include "vtkImageData.h"
#include "vtkTransform.h"

#include "vtkCamera.h"
#include "vtkImageActor.h"
#include <vtkImageMapToColors.h>
#include <vtkLookupTable.h>
#include <vtkCommand.h>

//#include "vtkMetaImageReader.h"

//------------------------------------------------------------------------------------------------------------
// Events declaration
//------------------------------------------------------------------------------------------------------------

//BEGIN_DECLARE_EVENT_TYPES()
//END_DECLARE_EVENT_TYPES()

/** file wxContourMainFrame.h */


//------------------------------------------------------------------------------------------------------------
// Class definition
//------------------------------------------------------------------------------------------------------------
class interfMainPanel;
class wxContourMainFrame : public wxPanel {

	public:

	//------------------------------------------------------------------------------------------------------------
	// Constructors & Destructors
	//------------------------------------------------------------------------------------------------------------


	wxContourMainFrame(wxWindow* parent, wxWindowID id,const wxString& title,const wxPoint& pos,const wxSize& size,long style  = wxDEFAULT_FRAME_STYLE | wxSUNKEN_BORDER);
	wxContourMainFrame(wxWindow* parent, wxWindowID id,const wxString& title,const wxPoint& pos,const wxSize& size,std::vector<vtkImageData*> images, long style  = wxDEFAULT_FRAME_STYLE | wxSUNKEN_BORDER,std::string datadir="C:/Creatis/creaContoursBin/RelWithDebInfo/");

	~wxContourMainFrame();

	//------------------------------------------------------------------------------------------------------------
	// Creational and initialization methods
	//------------------------------------------------------------------------------------------------------------

	void setVectImages(std::vector<vtkImageData*> imgs);

	bool configurePanels( );

	bool addNewPanel(wxPanel* panel);

	wxAuiNotebook * createNotebook();

	void createInstantChooserPanel(wxAuiNotebook * parent);

	void createViewPanel(wxAuiNotebook * parent);

	void createInstantChooserPanel(wxWindow * parent);

	void createViewPanel(wxWindow * parent);

	void setInstantChooserPanel(  wxInstantChooserPanel * theInstantChooserPanel );

	void getMaskValue(vtkImageData ** mask,vtkImageData ** value,int typeContourGroup, int selection, int minZ, int maxZ);

	void SaveImageResult(std::string directory,std::string namefile, vtkImageData* mask,vtkImageData* value);

	void ShowToolsPanel(bool show);


	////------------------------------------------------------------------------------------------------------------
	//// Methods for capturing events
	////------------------------------------------------------------------------------------------------------------


	////------------------------------------------------------------------------------------------------------------
	////  Model management methods
	////------------------------------------------------------------------------------------------------------------


	//------------------------------------------------------------------------------------------------------------
	//  Attributes getters and setters
	//------------------------------------------------------------------------------------------------------------
	static wxContourMainFrame* getInstance(wxWindow* parent, wxWindowID id,const wxString& title,const wxPoint& pos,const wxSize& size,std::vector<vtkImageData*> images, long style  = wxDEFAULT_FRAME_STYLE | wxSUNKEN_BORDER, std::string datadir="C:/Creatis/creaContoursBin/RelWithDebInfo/");
	static wxContourMainFrame* getInstance();
	static void resetInstance();

	//------------------------------------------------------------------------------------------------------------
	//  Other functional methods
	//------------------------------------------------------------------------------------------------------------

	/*
	** This method returns the vector of images selected by the user
	**	return value std::vector<vtkImageData*>
	*/
	std::vector<vtkImageData*> getVectImages();

	/**
	**	This methods connect the event in the class interfMainPanel with the world of the appli
	**/
	void onCreateContourSpline( );
	void onCreateContourRectangle( );
	void onCreateContourCircle( );
	void onCreateContourLine( );
	void onCreateContourPoints( );
	void onCreateContourPolygon( );
	void onCreateContourBullEye(wxPanel* pan);
	/////////////////////////////////
	void onDeleteContour();
	void deleteContours( std::vector<std::string>  keyNamesVector );
	void deleteContour( std::string theKeyName );
	void onDeleteContoursActSlice();
	void onDeleteAllContours();
	void deleteAllContours();
	void setConceptValue( std::string name, int value );
	ConceptDataWrap* getLastConceptData();
	bool getIfConceptCheckedAt( std::string name, int pos );

	void changeInstant();

	int getNamesWrappingSize();

	std::string getNameWrapping(int i);

	void updateInstantOutlines();
	void updateInstantImageData();
	void updateInstantAxes();

	void onChangeDeep(int val);

///////////////////////////
	void onCopy();
	void onPaste();
	void onUndo();
	void onRedo();
	void createCopyContourOf ( std::string anExistingKName, std::vector<int> &instantNoTouchData, bool append );
	void createMirrorContourOf ( std::string anExistingKName, std::vector<int> &instantNoTouchData, bool append );
///////////////////////7
	void onLoad();
	void onSave();
	void onImport();
	void onTest();
	void openContours( FILE *pFile, FILE *pFileData, bool staticContour );

	void RefreshInterface();

	vtkImageData* getImageData();

	void onSegmentationOneSlice(int isovalue,int sampling,int method);
	void onSegmentationOneSliceITK(wxString distance, wxString sigma, wxString alfa, wxString beta, wxString propagation, wxString iterations, wxString inflation);
	void SegmentationOneSlice( int x, int y, int z, int isovalue, int sampling, int method );
	void SegmentationOneSliceITK(int x, int y, int z, wxString distance, wxString sigma, wxString alfa, wxString beta, wxString propagation, wxString iterations, wxString inflation);
	void Mirror( int x, int y, int z, int isovalue, int sampling, int method );
	int  GetImageDataSizeZ();
	void GetImageDataRange(double *range);
	void onSegmentationAllSlice(int minZ,int maxZ,int isovalue,int sampling,int method);

	//AD
	void referenceLine();
	void refLineHide();
	void refLineShow();
	void refLineChangeWidth(int width);

	//AD
	void onMirror();

	//EED
	void FlipContours(int typeContourFlip, int flipDirection);
	void FlipSelectedContours(int flipDirection);
	void FlipActualSliceContours(int flipDirection);
	void FlipAllContours(int flipDirection);
	void FlipLstOfContours(std::vector<std::string> lstNameThings, int flipDirection);

		
//====================================================================================================

	void showAxis(bool show);
	void onRigidPressed();
	void onWidthOfContour(double width);
	int getColorWindow();
	int getWindowLevel();
	void onBrigthnessColorWindowLevel(int colorwindow,int windowlevel);
	void onInterpolation(bool interpolate);
	void onChangeInstant(std::string name,int actual);
	void resetAppend();
	void onSpreadAdd();
	void onSpreadAddAll();
	void onSpreadGo(int type);
	void getInstantVector(std::vector<int>& tempVector);
	std::vector<std::string> getOutlinesName(int slide);

	//
	//
	// @param typeContourGroup - int The operation id (AND,OR,XOR,ALL=3)
	//
	void onInformationContourLabels(int typeContourGroup,int selection,int minimumZ,int maximumZ,int grayRangeMin, int grayRangeMax);
	void onSaveResults(std::string directory,std::string namefile, std::string filename,
		int typeContourGroup, int selection, int minZ, int maxZ, bool XYZValues, bool contourImage, bool statistics);
	void SaveValuesXYZ(std::string directory,std::string namefile, int typeContourGroup);
	void onChangeInstantInstantPanel(std::string name,int value, int minshow, int maxshow);
	void onSnakePressed();
	void saveFileWithContoursAutomatique();
	void ShowResultImages(int typeContourGroup, int selection, int minZ, int maxZ );
	wxPanel *getMaskImageViewPanel(wxWindow *parent);
	void SetContourGroup(int contourGroup);
	wxPanel *getThresholdImageViewPanel(wxWindow *parent);
	wxPanel *getColorLayerImageViewPanel(wxWindow *parent);


//CMRU 17-08-09-----------------------------------------------------------------------------------------------

	/**
	* Associates the String parameter with the contour
	* @param label Label entered by the user
	* @param manualBaseModel Currently selected contour
	*/
	void onPrintLabel (wxString label, manualBaseModel* manualModel);

	/**
	* Calculates the size of the contour received as a parameter. Uses the measure of a pixel in millimeters.
	* @param manualBaseModel Currently selected contour
	*/
	void onInsertCalculation(manualBaseModel* manualModel);

	/**
	* Assigns and returns the value of a pixel in millimeters
	@ param value Measure of the pixel in millimeters
	*/
	double onePixelSize(double value);

	/**
	* Returns the type of the currently selected contour
	*/
	int getType();

	/**
	* Returns the size in pixels of the currently selected contour
	*/
	double getContourSizeInPixels();

	/**
	* Returns the currently selected contour. If no contour is selected returns NULL
	*/
	manualBaseModel* getContour();

	/**
	* Returns the Path of the data persistence file
	*/
	std::string GetFileLocation();

	/**
	* Assign a new path to the data persistence file
	@ param newFileLocation New path of the file
	*/
	void SetFileLocation(std::string newFileLocation);
//------------------------------------------------------------------------------------------------------------

	void SetScalarRange(int grayRangeMin, int grayRangeMax);

//------------------------------------------------------------------------------------------------------------

private:
	//------------------------------------------------------------------------------------------------------------
	//  Private methods
	//------------------------------------------------------------------------------------------------------------


	//------------------------------------------------------------------------------------------------------------
	// Attributtes
	//------------------------------------------------------------------------------------------------------------

	int _contourGroup;
	static wxContourMainFrame   *instance;
	KernelManagerContour        *kernelManager;
	interfMainPanel             *_pannew;
	PerformingOperation         *_performingOperation;
	std::string                 _datadir;
	wxContourViewPanel          *_theViewPanel;
	wxInstantChooserPanel       *_instantPanel;

	//AD: 03-09: This attributes represents the reference line that is going to be used for the mirroring
	manualLineControler         *_refLineControl;
	manualContourModelLine      *_refLineModel;
	manualViewLine              *_refLineView;

	wxAuiManager                m_mgr;
	wxAuiNotebook               *notebook;
    	long                        m_notebook_style;
    	long                        m_notebook_theme;
    	int                         _numberOfVariablesStatistics;

	// Contour Image Mask
	ThresholdImageView		*_viewMaskImage;
	ThresholdImageViewPanel		*_viewMaskImagePanel;

	// Threshold Image
	ThresholdImageView		*_viewThresholdImage;
	ThresholdImageViewPanel		*_viewThresholdImagePanel;

	// Color Layer Image
	ColorLayerImageViewPanel	*_viewColorLayerImagePanel;
	std::vector<vtkImageData*>  _images;
	bool                        _actorPresent;

    // temporary variables readding .roi file
    int             _tmpReadFileImageDim[3];
	double          _tmpReadFileImageSpac[3];
    int             _tmpReadFileTypeOfTransformation;
    void readDimSpc(FILE *pFile, bool interactiveOption);


	/*DECLARE_CLASS(wxContourMainFrame)
	// any class wishing to process wxWindows events must use this macro
	DECLARE_EVENT_TABLE()*/
	bool                        _creatingContoursActive;
////////JCP 21 - 11 - 08
	void createContour( int typeContour );
	//manualContourModel * factoryManualContourModel(int typeContour);
	manualBaseModel * factoryManualContourModel(wxPanel* panel);
	ContourExtractData	        *_contourextractdata;

	void saveState();
	void loadState(std::string filename);

//	void loadContours( FILE *pFile, bool staticContour );

	void saveFileWithContours( std::string filename );
	void onLoadContours(std::string fileNameContourROI, bool interactiveInterface);
	void SetZForAllContours(int pz);

	int                         inredo;
	int                         inundo;
	std::string	                stundoredo;
	static char                 COPY;

//CMRU 17-08-09-----------------------------------------------------------------------------------------------
	wxWindow                    *infoWin2;
	wxPanel                     *calibrationPanel;
	wxPanel                     *calibrationPanelError;
	double                      _onePixelSize;
	std::string                 _imageLocation;
	std::string                 _fileLocation;
//------------------------------------------------------------------------------------------------------------

};

#endif
